/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.distributed.lock.impl;

import cn.com.yusys.yusp.commons.distributed.lock.impl.DistributedLock;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RedisDistributedLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private final long lockTimeout;
    private ThreadLocal<RLock> lockContext = new ThreadLocal();
    @Autowired
    private RedissonClient redissonClient;

    public RedisDistributedLock(long lockTimeout) {
        this.lockTimeout = lockTimeout > 0L ? lockTimeout : 300000L;
    }

    @Override
    public boolean tryLock(String key) {
        RLock rlock = this.redissonClient.getLock(key);
        this.lockContext.set(rlock);
        return rlock.tryLock();
    }

    @Override
    public void unlock(String key) {
        RLock rlock = this.lockContext.get();
        rlock.unlock();
    }

    @Override
    public void lock(String key, long blockTime) {
        while (!this.tryLock(key)) {
            try {
                Thread.sleep(blockTime);
            }
            catch (Exception e) {
                log.error("failed to lock " + key, (Throwable)e);
                throw new PlatformException(String.format("failed to lock,key: %s", key), (Throwable)e);
            }
        }
    }
}

