/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.distributed.lock.impl;

import cn.com.yusys.yusp.commons.distributed.lock.LockUtils;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.domain.LockInfo;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.service.LockInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public class DatabaseDistributedLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDistributedLock.class);
    private final long lockTimeout;
    private final LockInfoService lockInfoService;

    public DatabaseDistributedLock(LockInfoService lockInfoService, long lockTimeout) {
        this.lockInfoService = lockInfoService;
        this.lockTimeout = lockTimeout > 0L ? lockTimeout : 300000L;
    }

    @Override
    public boolean tryLock(String key) {
        String pid = LockUtils.getThreadId();
        LockInfo nodeData = this.lockInfoService.selectByPrimaryKey(key);
        if (null != nodeData) {
            long lockTime;
            if (nodeData.getThreadName().equals(pid)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now - (lockTime = Long.parseLong(nodeData.getCreateTime())) > this.lockTimeout) {
                LockInfo lockInfo = new LockInfo();
                lockInfo.setLockId(key);
                lockInfo.setCreateTime(String.valueOf(now));
                lockInfo.setThreadName(pid);
                lockInfo.setExt(nodeData.getCreateTime());
                return this.updateCreateTimeCas(lockInfo);
            }
            return false;
        }
        try {
            LockInfo lockInfo = new LockInfo();
            lockInfo.setCreateTime(System.currentTimeMillis() + "");
            lockInfo.setLockId(key);
            lockInfo.setThreadName(pid);
            this.insertLockInfo(lockInfo);
            log.info("Lock key:{} get lock success!", (Object)key);
            return true;
        }
        catch (DuplicateKeyException e) {
            log.info("Lock key:{} try lock failure! cause by:lock has exist", (Object)key);
        }
        catch (Exception e) {
            log.error("Lock key:{} try lock failure! cause by:{}", (Object)key, (Object)e.getMessage());
        }
        return false;
    }

    boolean updateCreateTimeCas(LockInfo lockInfo) {
        int result = this.lockInfoService.updateCreateTimeCas(lockInfo);
        return 0 != result;
    }

    void insertLockInfo(LockInfo lockInfo) {
        this.lockInfoService.insertSelective(lockInfo);
    }

    @Override
    public void unlock(String key) {
        this.lockInfoService.deleteByPrimaryKey(key);
        log.info("success to unlock for path:{}", (Object)key);
    }

    @Override
    public void lock(String key, long blockTime) {
        this.lockInfoService.selectByPrimaryKeyForUpdate(key, blockTime, LockUtils.getThreadId());
    }
}

