/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.server.store;

import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataStore;
import cn.com.yusys.yusp.commons.route.jdbc.core.connection.DataRouteHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JdbcTemplateSyncDataStore
implements SyncDataStore {
    private static final Logger log = LoggerFactory.getLogger(JdbcTemplateSyncDataStore.class);
    private static final String SEARCH_SQL = "SELECT * FROM %s";
    private static final String SEARCH_COUNT_SQL = "SELECT COUNT(1) FROM %s";
    private static final String DELETE_SQL = "DELETE FROM %s";
    private static final String INSERT_SQL = "INSERT INTO %s (%s) VALUES (%s)";
    private static final String PARAM_DELIMITER = ",";
    private static final String PARAM_PLACEHOLDER = "?";
    private final Object lock = new Object();
    private final Map<String, String> cacheInsertSql = new ConcurrentHashMap<String, String>();
    private final JdbcTemplate jdbcTemplate;

    public JdbcTemplateSyncDataStore(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void store(SyncData syncData, String schema) {
        String table = syncData.getTable();
        String sql = syncData.getSql();
        try {
            DataRouteHandler.DATA_SOURCE_NAME.set(schema);
            log.debug("schema[{}] table[{}] execute sql:{}", new Object[]{schema, table, sql});
            this.jdbcTemplate.update(sql, syncData.getArgs());
        }
        finally {
            DataRouteHandler.DATA_SOURCE_NAME.remove();
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void store(SyncData syncData) {
        String table = syncData.getTable();
        String sql = syncData.getSql();
        log.debug("table[{}] execute sql:{}", (Object)table, (Object)sql);
        this.jdbcTemplate.update(sql, syncData.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> search(String schema, String table) {
        List records;
        try {
            DataRouteHandler.DATA_SOURCE_NAME.set(schema);
            log.debug("schema[{}] table[{}] search records.", (Object)schema, (Object)table);
            records = this.jdbcTemplate.queryForList(String.format(SEARCH_SQL, table));
        }
        finally {
            DataRouteHandler.DATA_SOURCE_NAME.remove();
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer count(String schema, String table) {
        Integer count;
        try {
            DataRouteHandler.DATA_SOURCE_NAME.set(schema);
            log.debug("schema[{}] table[{}] search count records.", (Object)schema, (Object)table);
            count = (Integer)this.jdbcTemplate.queryForObject(String.format(SEARCH_COUNT_SQL, table), Integer.class);
        }
        finally {
            DataRouteHandler.DATA_SOURCE_NAME.remove();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Integer store(String schema, String table, List<Map<String, Object>> records) {
        Integer count;
        int size = records.size();
        if (size != (count = this.count(schema, table))) {
            log.debug("table :{} schema :{} records un matched.", (Object)table, (Object)schema);
            try {
                DataRouteHandler.DATA_SOURCE_NAME.set(schema);
                log.debug("schema[{}] table[{}] delete records.", (Object)schema, (Object)table);
                count = this.jdbcTemplate.update(String.format(DELETE_SQL, table));
                log.debug("schema[{}] table[{}] batch insert records.", (Object)schema, (Object)table);
                int[] updates = this.batchInsert(table, records);
                if (log.isDebugEnabled()) {
                    log.debug("table[{}] update records complete,delete count:{}, insert count:{}.", new Object[]{table, count, Arrays.stream(updates).count()});
                }
            }
            finally {
                DataRouteHandler.DATA_SOURCE_NAME.remove();
            }
        }
        return count;
    }

    int[] batchInsert(String table, List<Map<String, Object>> records) {
        if (Objects.nonNull(records) && !records.isEmpty()) {
            String insertSql = this.genSql(table, records);
            return this.jdbcTemplate.batchUpdate(insertSql, records.stream().map(Map::values).map(Collection::toArray).collect(Collectors.toList()));
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String genSql(String table, List<Map<String, Object>> records) {
        String insertSql = this.cacheInsertSql.get(table);
        if (Objects.isNull(insertSql)) {
            Object object = this.lock;
            synchronized (object) {
                Map<String, Object> params = records.get(0);
                insertSql = String.format(INSERT_SQL, table, String.join((CharSequence)PARAM_DELIMITER, params.keySet()), this.valuesSql(PARAM_DELIMITER, PARAM_PLACEHOLDER, params.size()));
                log.debug("Table[{}] insert sql:{}", (Object)table, (Object)insertSql);
                this.cacheInsertSql.put(table, insertSql);
            }
        }
        return insertSql;
    }

    String valuesSql(String delimiter, String value, int size) {
        StringJoiner values = new StringJoiner(delimiter);
        for (int i = 0; i < size; ++i) {
            values.add(value);
        }
        return values.toString();
    }
}

