/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.server.service;

import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataService;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class SyncDataWithoutRouteServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncDataWithoutRouteServiceImpl.class);
    private final SyncDataStore syncDataStore;

    public SyncDataWithoutRouteServiceImpl(SyncDataStore syncDataStore) {
        this.syncDataStore = syncDataStore;
    }

    @Override
    public void handle(SyncData syncData) {
        String table = syncData.getTable();
        log.debug("Domain:{} ,table :{} data change.trigger sync.", (Object)syncData.getDomain(), (Object)table);
        this.syncDataStore.store(syncData);
    }

    @Override
    public void exceptionHandle(Throwable ex, Message<?> message) {
        log.debug("Message consumer failure, reject message.");
    }

    @Override
    public void competeHandle() {
        log.debug("Message consumer compete.");
    }
}

