/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.commons.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoUtils {
    protected static final ThreadLocal<Kryo> kryoLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setReferences(true);
        kryo.setRegistrationRequired(false);
        ((Kryo.DefaultInstantiatorStrategy)kryo.getInstantiatorStrategy()).setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        return kryo;
    });

    private KryoUtils() {
    }

    public static Kryo getInstance() {
        return kryoLocal.get();
    }

    public static <T> byte[] writeToByteArray(T obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)byteArrayOutputStream);
        Kryo kryo = KryoUtils.getInstance();
        kryo.writeClassAndObject(output, obj);
        output.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> String writeToString(T obj) {
        return new String(Base64.encodeBase64((byte[])KryoUtils.writeToByteArray(obj)), StandardCharsets.UTF_8);
    }

    public static <T> T readFromByteArray(byte[] byteArray) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        Input input = new Input((InputStream)inputStream);
        Kryo kryo = KryoUtils.getInstance();
        return (T)kryo.readClassAndObject(input);
    }

    public static <T> T readFormString(String str) {
        return KryoUtils.readFromByteArray(Base64.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }
}

