/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.client.report;

import cn.com.yusys.yusp.commons.datasync.client.SyncDataSender;
import cn.com.yusys.yusp.commons.datasync.client.report.AbstractSyncDataReporter;
import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class SyncDataQueueAsyncReporter
extends AbstractSyncDataReporter
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(SyncDataQueueAsyncReporter.class);
    public static final String THREAD_NAME = "DB-change-data-%d";
    private final LinkedBlockingQueue<SyncData> changeDataQueue = new LinkedBlockingQueue();
    private final AtomicBoolean started = new AtomicBoolean(false);

    public SyncDataQueueAsyncReporter(SyncDataSender sender) {
        super(sender);
    }

    @Override
    public void report(SyncData syncData) {
        boolean success = this.changeDataQueue.offer(syncData);
        if (!success) {
            log.warn("Add Table SyncData failed.");
        }
    }

    public void start() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(THREAD_NAME).setDaemon(true).build();
        threadFactory.newThread(this::send).start();
        this.started.compareAndSet(false, true);
    }

    protected void send() {
        do {
            try {
                SyncData data = this.changeDataQueue.take();
                super.send(data);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:{}.", (Object)e.getMessage());
            }
        } while (this.started.get());
    }

    public void stop() {
        this.started.compareAndSet(true, false);
    }

    public boolean isRunning() {
        return this.started.get();
    }
}

