/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.client.util;

import cn.com.yusys.yusp.commons.mybatis.util.PluginUtils;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import java.sql.PreparedStatement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MybatisSqlUtils {
    private MybatisSqlUtils() {
    }

    public static String getSqlFromStatementHandler(StatementHandler statementHandler) {
        MetaObject metaObjectHandler = SystemMetaObject.forObject((Object)PluginUtils.realTarget((Object)statementHandler));
        return MybatisSqlUtils.replace((String)metaObjectHandler.getValue("delegate.boundSql.sql"));
    }

    public static String replace(String origin) {
        return origin.replace("\n", "");
    }

    public static Object[] getParamsFromStatementHandler(StatementHandler statementHandler) {
        MetaObject metaObjectHandler = SystemMetaObject.forObject((Object)PluginUtils.realTarget((Object)statementHandler));
        BoundSql boundSql = (BoundSql)metaObjectHandler.getValue("delegate.boundSql");
        MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
        CustomizedParameterHandler customizedParameterHandler = new CustomizedParameterHandler(mappedStatement, statementHandler.getParameterHandler().getParameterObject(), boundSql);
        customizedParameterHandler.setParameters(null);
        return customizedParameterHandler.getParameters();
    }

    public static String sqlId(StatementHandler statementHandler) {
        MetaObject metaObjectHandler = SystemMetaObject.forObject((Object)PluginUtils.realTarget((Object)statementHandler));
        MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
        return mappedStatement.getId();
    }

    private static class CustomizedParameterHandler
    implements ParameterHandler {
        private final TypeHandlerRegistry typeHandlerRegistry;
        private final Object parameterObject;
        private final BoundSql boundSql;
        private final Configuration configuration;
        private Object[] params;

        public CustomizedParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
            this.configuration = mappedStatement.getConfiguration();
            this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
            this.parameterObject = parameterObject;
            this.boundSql = boundSql;
        }

        public Object getParameterObject() {
            return this.parameterObject;
        }

        public Object[] getParameters() {
            return this.params;
        }

        public void setParameters(PreparedStatement ps) {
            LinkedList<Object> listParams = new LinkedList<Object>();
            List parameterMappings = this.boundSql.getParameterMappings();
            if (parameterMappings == null) {
                this.params = listParams.toArray();
                return;
            }
            for (ParameterMapping parameterMapping : parameterMappings) {
                if (ParameterMode.OUT == parameterMapping.getMode()) continue;
                listParams.add(this.paramValue(parameterMapping));
            }
            this.params = listParams.toArray();
        }

        private Object paramValue(ParameterMapping parameterMapping) {
            Object value = null;
            String propertyName = parameterMapping.getProperty();
            if (this.boundSql.hasAdditionalParameter(propertyName)) {
                value = this.boundSql.getAdditionalParameter(propertyName);
            } else {
                if (this.parameterObject == null) {
                    return null;
                }
                if (this.typeHandlerRegistry.hasTypeHandler(this.parameterObject.getClass())) {
                    value = this.parameterObject;
                } else if (propertyName.startsWith("__frch")) {
                    if (Map.class.isAssignableFrom(this.parameterObject.getClass())) {
                        value = this.frchMapValue(propertyName);
                    }
                } else {
                    MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
                    if (metaObject.hasGetter(propertyName)) {
                        value = metaObject.getValue(propertyName);
                    }
                }
            }
            return value;
        }

        private Object frchMapValue(String propertyName) {
            Object value = null;
            MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
            if (metaObject.hasGetter("array")) {
                Object[] array = (Object[])metaObject.getValue("array");
                value = array[NumberUtils.toInteger((Object)propertyName.substring(propertyName.length() - 1), (Integer)0)];
            } else if (metaObject.hasGetter("list")) {
                List list = (List)metaObject.getValue("list");
                value = list.get(NumberUtils.toInteger((Object)propertyName.substring(propertyName.length() - 1), (Integer)0));
                String actualParameter = propertyName.substring(0, propertyName.lastIndexOf("_")).replace("__frch_", "");
                if (actualParameter.contains(".")) {
                    MetaObject object = this.configuration.newMetaObject(value);
                    value = object.getValue(actualParameter.substring(actualParameter.indexOf(".") + 1));
                }
            }
            return value;
        }
    }
}

