/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.client.config;

import cn.com.yusys.yusp.commons.datasync.client.DataSyncClientConfig;
import cn.com.yusys.yusp.commons.datasync.client.SyncDataMybatisInterceptor;
import cn.com.yusys.yusp.commons.datasync.client.SyncDataReporter;
import cn.com.yusys.yusp.commons.datasync.client.SyncDataSender;
import cn.com.yusys.yusp.commons.datasync.client.report.SimpleSyncDataReporter;
import cn.com.yusys.yusp.commons.datasync.client.report.SyncDataQueueAsyncReporter;
import cn.com.yusys.yusp.commons.datasync.client.send.MessageSyncDataSender;
import cn.com.yusys.yusp.commons.message.MqPublisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"yusp.data-sync.client"}, havingValue="true", matchIfMissing=true)
public class SyncDataClientAutoConfiguration {
    public static final String DATA_SYNC_CLIENT = "yusp.data-sync.client";
    public static final String DATA_SYNC_REPORT_PREFIX = "yusp.data-sync.client.report";

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="yusp.data-sync.client")
    public DataSyncClientConfig dataSyncClientConfig() {
        return new DataSyncClientConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"yusp.data-sync.client.report"}, havingValue="async")
    public SyncDataReporter asyncDataReporter(ObjectProvider<SyncDataSender> senderObjectProvider) {
        return new SyncDataQueueAsyncReporter((SyncDataSender)senderObjectProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"yusp.data-sync.client.report"}, havingValue="sync", matchIfMissing=true)
    public SyncDataReporter syncDataReporter(ObjectProvider<SyncDataSender> senderObjectProvider) {
        return new SimpleSyncDataReporter((SyncDataSender)senderObjectProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public SyncDataMybatisInterceptor syncDataMybatisInterceptor(DataSyncClientConfig config, SyncDataReporter reporter) {
        return new SyncDataMybatisInterceptor(config, reporter);
    }

    @Configuration
    @ConditionalOnClass(value={MqPublisher.class})
    static class MessageDataSyncConfiguration {
        MessageDataSyncConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={SyncDataSender.class})
        public SyncDataSender messageSyncDataSender() {
            return new MessageSyncDataSender();
        }
    }
}

