/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.client;

import cn.com.yusys.yusp.commons.datasync.client.DataSyncClientConfig;
import cn.com.yusys.yusp.commons.datasync.client.SyncDataReporter;
import cn.com.yusys.yusp.commons.datasync.client.util.MybatisSqlUtils;
import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.util.AntPathMatcher;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class})})
public class SyncDataMybatisInterceptor
implements Interceptor {
    private final DataSyncClientConfig config;
    private final AntPathMatcher mapperMatcher = new AntPathMatcher(".");
    private final Map<String, String> cacheTable = new HashMap<String, String>();
    private final SyncDataReporter syncDataReporter;

    public SyncDataMybatisInterceptor(DataSyncClientConfig config, SyncDataReporter syncDataReporter) {
        this.config = config;
        this.syncDataReporter = syncDataReporter;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        String sqlId = MybatisSqlUtils.sqlId(statementHandler);
        String table = this.table(sqlId);
        if (StringUtils.nonBlank((CharSequence)table)) {
            String sql = MybatisSqlUtils.getSqlFromStatementHandler(statementHandler);
            Object[] params = MybatisSqlUtils.getParamsFromStatementHandler(statementHandler);
            String domain = "test";
            SyncData data = SyncData.builder().domain(domain).sql(sql).args(params).table(table).build();
            this.syncDataReporter.report(data);
        }
        return result;
    }

    String table(String sqlId) {
        String table = this.cacheTable.get(sqlId);
        if (StringUtils.nonEmpty((CharSequence)table)) {
            return table;
        }
        for (Map.Entry<String, List<String>> entry : this.config.getTables().entrySet()) {
            String tab = entry.getKey();
            List<String> patterns = entry.getValue();
            boolean matched = patterns.stream().anyMatch(pattern -> this.mapperMatcher.match(pattern, sqlId));
            if (!matched) continue;
            this.cacheTable.put(sqlId, tab);
            return tab;
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

