/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.util;

public final class JSONTemplateUtils {
    private JSONTemplateUtils() {
    }

    public static <T> StringBuilder start(String name, Class<T> type) {
        StringBuilder json = new StringBuilder("%7B");
        json.append((CharSequence)JSONTemplateUtils.param(name, type));
        json.append("%7D");
        return json;
    }

    public static <T> String append(String json, String name, Class<T> type) {
        StringBuilder append = JSONTemplateUtils.param(name, type).append(",");
        return new StringBuilder(json).insert(3, append).toString();
    }

    public static <T> void append(StringBuilder json, String name, Class<T> type) {
        StringBuilder append = JSONTemplateUtils.param(name, type).append(",");
        json.insert(3, append);
    }

    public static <T> StringBuilder param(String name, Class<T> type) {
        StringBuilder json = new StringBuilder();
        boolean number = JSONTemplateUtils.isNum(type);
        json.append("\"").append(name).append("\":");
        if (number) {
            json.append("{").append(name).append("}");
        } else {
            json.append("\"").append("{").append(name).append("}").append("\"");
        }
        return json;
    }

    public static boolean isNum(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Boolean.TYPE || type == Boolean.class || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }
}

