/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.header.feign;

import cn.com.yusys.yusp.commons.context.header.annonation.MessageBody;
import cn.com.yusys.yusp.commons.context.util.JSONTemplateUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import feign.MethodMetadata;
import feign.RequestTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;

public class MessageAnnotatedParameterProcessor
implements AnnotatedParameterProcessor {
    public Class<? extends Annotation> getAnnotationType() {
        return MessageBody.class;
    }

    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        int paramIndex = context.getParameterIndex();
        MethodMetadata metadata = context.getMethodMetadata();
        MessageBody messageBody = (MessageBody)annotation;
        String paramName = messageBody.value();
        if (StringUtils.isEmpty((CharSequence)paramName)) {
            metadata.bodyIndex(Integer.valueOf(paramIndex));
            metadata.bodyType(method.getParameterTypes()[paramIndex]);
        } else {
            Map names = metadata.indexToName();
            names.put(paramIndex, Collections.singletonList(paramName));
            Class<?> paramType = method.getParameterTypes()[paramIndex];
            RequestTemplate requestTemplate = metadata.template();
            String bodyTemplate = requestTemplate.bodyTemplate();
            if (StringUtils.isEmpty((CharSequence)bodyTemplate)) {
                if (!requestTemplate.headers().containsKey("content-type")) {
                    metadata.template().header("content-type", new String[]{"application/json; charset=utf-8"});
                }
                bodyTemplate = JSONTemplateUtils.start(paramName, paramType).toString();
            } else {
                bodyTemplate = JSONTemplateUtils.append(bodyTemplate, paramName, paramType);
            }
            requestTemplate.bodyTemplate(bodyTemplate, StandardCharsets.UTF_8);
        }
        return true;
    }
}

