/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.feign;

import cn.com.yusys.yusp.commons.context.ContextProcessor;
import cn.com.yusys.yusp.commons.context.ContextProcessorFactory;
import cn.com.yusys.yusp.commons.context.util.ContextHolderUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import feign.FeignException;
import feign.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;

public class EnhanceFeignSpringDecoder
extends SpringDecoder {
    private final ContextProcessor<String> contextProcessor;

    public EnhanceFeignSpringDecoder(ObjectFactory<HttpMessageConverters> messageConverters, ContextProcessorFactory contextProcessorFactory) {
        super(messageConverters);
        this.contextProcessor = contextProcessorFactory.create(name -> name);
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        this.extraContextFormResponse(response);
        return super.decode(response, type);
    }

    private void extraContextFormResponse(Response response) {
        ContextHolderUtils.extraContext(this.contextProcessor, response, (carrier, key) -> this.getContextInfo((String)key, (Response)carrier));
    }

    private String getContextInfo(String key, Response response) {
        Map headers = response.headers();
        if (CollectionUtils.isEmpty((Map)headers)) {
            return null;
        }
        Collection header = (Collection)headers.get(key);
        if (CollectionUtils.isEmpty((Collection)header)) {
            return null;
        }
        return header.toArray(new String[0])[0];
    }
}

