/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.brave;

import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import cn.com.yusys.yusp.commons.context.ContextProcessor;
import cn.com.yusys.yusp.commons.context.ContextProcessorFactory;
import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import java.util.List;

public class ContextPropagation<K>
implements Propagation<K> {
    public static final String CONTEXT_KEY = "context-prop";
    public static final String CONTEXT_ITEM_PRE = "context-prop-";
    public static final String ENCODING_UTF8 = "utf-8";
    private final Propagation<K> delegate;
    private final ContextProcessor<K> contextProcessor;

    public ContextPropagation(Propagation<K> delegate, ContextProcessor<K> contextProcessor) {
        this.delegate = delegate;
        this.contextProcessor = contextProcessor;
    }

    public List<K> keys() {
        return this.delegate.keys();
    }

    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return new ContextInjector<C, K>(this, setter);
    }

    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        return new ContextExtractor<C, K>(this, getter);
    }

    static ContextHolder findExtra(TraceContext traceContext) {
        return traceContext.extra().stream().filter(extra -> ContextHolder.class == extra.getClass()).map(ContextHolder.class::cast).reduce(ContextPropagation::combine).orElse(new ContextHolder());
    }

    static ContextHolder combine(ContextHolder newHolder, ContextHolder oldHolder) {
        newHolder.items.forEach(oldHolder.items::put);
        return oldHolder;
    }

    static final class ContextExtractor<C, K>
    implements TraceContext.Extractor<C> {
        private final ContextPropagation<K> propagation;
        private final TraceContext.Extractor<C> delegate;
        private final Propagation.Getter<C, K> getter;

        public ContextExtractor(ContextPropagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.delegate = ((ContextPropagation)propagation).delegate.extractor(getter);
            this.getter = getter;
            this.propagation = propagation;
        }

        public TraceContextOrSamplingFlags extract(C carrier) {
            TraceContextOrSamplingFlags traceContext = this.delegate.extract(carrier);
            ContextHolder contextHolder = ((ContextPropagation)this.propagation).contextProcessor.extract(carrier, this.getter);
            return traceContext.toBuilder().addExtra((Object)contextHolder).build();
        }
    }

    static final class ContextInjector<C, K>
    implements TraceContext.Injector<C> {
        private final ContextPropagation<K> propagation;
        private final TraceContext.Injector<C> delegate;
        private final Propagation.Setter<C, K> setter;

        public ContextInjector(ContextPropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.propagation = propagation;
            this.delegate = ((ContextPropagation)propagation).delegate.injector(setter);
            this.setter = setter;
        }

        public void inject(TraceContext traceContext, C carrier) {
            this.delegate.inject(traceContext, carrier);
            ContextHolder holder = ContextPropagation.findExtra(traceContext);
            ((ContextPropagation)this.propagation).contextProcessor.inject(carrier, this.setter, holder);
        }
    }

    public static final class ContextFactory
    extends Propagation.Factory {
        private final Propagation.Factory delegate;
        private final ContextProcessorFactory processorFactory;

        public ContextFactory(Propagation.Factory delegate, ContextProcessorFactory processorFactory) {
            this.delegate = delegate;
            this.processorFactory = processorFactory;
        }

        public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            return new ContextPropagation<K>(this.delegate.create(keyFactory), this.processorFactory.create(keyFactory));
        }

        public boolean supportsJoin() {
            return this.delegate.supportsJoin();
        }

        public boolean requires128BitTraceId() {
            return this.delegate.requires128BitTraceId();
        }

        public TraceContext decorate(TraceContext context) {
            return this.delegate.decorate(context);
        }
    }
}

