/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.trace.rest;

import cn.com.yusys.yusp.commons.context.ContextProcessor;
import cn.com.yusys.yusp.commons.context.util.ContextHolderUtils;
import cn.com.yusys.yusp.commons.rest.AbstractClientHttpRequestInterceptor;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;

public class RestTemplateResponseContextInterceptor
extends AbstractClientHttpRequestInterceptor {
    private final ContextProcessor<String> contextProcessor;

    public RestTemplateResponseContextInterceptor(ContextProcessor<String> contextProcessor) {
        this.contextProcessor = contextProcessor;
    }

    public ClientHttpResponse intercept(@NonNull HttpRequest request, @NonNull byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response = super.intercept(request, body, execution);
        ContextHolderUtils.extraContext(this.contextProcessor, response, (resp, key) -> this.getContextInfo((String)key, (ClientHttpResponse)resp));
        return response;
    }

    private String getContextInfo(String key, ClientHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        List header = headers.get((Object)key);
        if (Objects.isNull(header) || CollectionUtils.isEmpty((Collection)header)) {
            return null;
        }
        return header.toArray(new String[0])[0];
    }
}

