/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.header.resolver;

import cn.com.yusys.yusp.commons.context.exception.ContextException;
import cn.com.yusys.yusp.commons.context.header.annonation.MessageBody;
import cn.com.yusys.yusp.commons.context.header.process.MessageProcessor;
import cn.com.yusys.yusp.commons.context.header.resolver.AbstractMessageAnnotationMethodArgumentResolver;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;

public class MessageBodyMethodProcessor
extends AbstractMessageAnnotationMethodArgumentResolver {
    private final Logger log = LoggerFactory.getLogger(MessageBodyMethodProcessor.class);

    public MessageBodyMethodProcessor(MessageProcessor messageProcessor) {
        super(messageProcessor);
    }

    @Override
    protected boolean isRequired(MethodParameter parameter) {
        return ((MessageBody)Objects.requireNonNull(parameter.getParameterAnnotation(MessageBody.class))).required();
    }

    @Override
    protected void validateInternal(MethodParameter parameter, Object result, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        if (Objects.nonNull(binderFactory)) {
            try {
                WebDataBinder webDataBinder = binderFactory.createBinder(webRequest, result, parameter.getGenericParameterType().getTypeName());
                this.validate(parameter, webDataBinder);
            }
            catch (Exception e) {
                throw new ContextException("Validate parameter failed.", e);
            }
        }
    }

    protected void validate(MethodParameter parameter, @Nullable WebDataBinder binder) throws MethodArgumentNotValidException {
        Annotation[] annotations;
        for (Annotation annotation : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnna = (Validated)parameter.getParameterAnnotation(Validated.class);
            if (validatedAnna == null && !annotation.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnna != null ? validatedAnna.value() : AnnotationUtils.getValue((Annotation)annotation);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            if (Objects.isNull(binder)) {
                throw new ContextException("Validated Annotation is present, but not find WebDataBinder.");
            }
            binder.validate(validationHints);
            break;
        }
        if (Objects.nonNull(binder) && binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
            throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
        }
    }

    @Override
    protected Object resolveBodyArgument(MethodParameter parameter, Object params) {
        if (Objects.isNull(params)) {
            this.log.warn("Missing RequestBody,Can't resolve param:{} with annotation @MessageBody.", (Object)parameter.getParameterName());
            return null;
        }
        Object toParseBody = this.getMessageProcessor().extractBody(params);
        if (Objects.isNull(toParseBody)) {
            this.log.warn("RequestBody missing necessary body.");
            return null;
        }
        MessageBody messageBody = (MessageBody)parameter.getParameterAnnotation(MessageBody.class);
        String name = Optional.ofNullable(messageBody).map(MessageBody::value).orElse("");
        if (StringUtils.nonEmpty((CharSequence)name)) {
            if (!(toParseBody instanceof Map)) {
                this.log.warn("RequestBody not is Map,Can't Parse MessageBody:{}.", (Object)name);
                return null;
            }
            if (Objects.isNull(toParseBody = ((Map)toParseBody).get(name))) {
                this.log.warn("RequestBody not exist key:{}", (Object)name);
                return null;
            }
        }
        Type parameterType = parameter.getGenericParameterType();
        try {
            return ObjectMapperUtils.instance().convertValue(toParseBody, TypeFactory.defaultInstance().constructType(parameterType));
        }
        catch (Exception e) {
            this.log.warn(String.format("Convert body to [%s] failed.", parameterType.getTypeName()), (Throwable)e);
            return null;
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(MessageBody.class);
    }
}

