/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.brave;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import cn.com.yusys.yusp.commons.context.brave.ContextPropagation;
import cn.com.yusys.yusp.commons.context.exception.ContextException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ContextHolder {
    final Map<String, Object> items = new HashMap<String, Object>();

    public static <T> Optional<T> getContext(Class<T> clazz) {
        return ContextHolder.load().map(contextHolder -> contextHolder.get(clazz));
    }

    public static <T> T putContext(T item) {
        return ContextHolder.load().orElseThrow(() -> new ContextException("Not find ContextHolder in TraceContext.")).put(item);
    }

    public static boolean exists() {
        return ContextHolder.load().isPresent();
    }

    public static Optional<ContextHolder> load() {
        return Optional.ofNullable(Tracing.current()).map(Tracing::currentTraceContext).map(CurrentTraceContext::get).map(ContextPropagation::findExtra);
    }

    public static ContextHolder get() {
        return ContextHolder.load().orElse(new ContextHolder());
    }

    public <T> T put(T object) {
        return (T)this.items.put(object.getClass().getName(), object);
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.items.get(clazz.getName());
    }

    public Map<String, Object> getItems() {
        return this.items;
    }

    public void reset() {
        ContextHolder.load().ifPresent(contextHolder -> {
            contextHolder.items.clear();
            contextHolder.items.putAll(this.items);
        });
    }
}

