/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.clean.task.service;

import cn.com.yusys.yusp.commons.clean.config.DataClean;
import cn.com.yusys.yusp.commons.clean.task.domain.DataCleanConfig;
import cn.com.yusys.yusp.commons.clean.task.domain.DataCleanLog;
import cn.com.yusys.yusp.commons.clean.task.mapper.DataCleanConfigMapper;
import cn.com.yusys.yusp.commons.clean.task.mapper.DataCleanLogMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class DataCleanLogService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanLogService.class);
    DataCleanLogMapper dataCleanLogMapper;
    DataCleanConfigMapper dataCleanConfigMapper;

    public DataCleanLogService(DataCleanLogMapper dataCleanLogMapper, DataCleanConfigMapper dataCleanConfigMapper) {
        this.dataCleanLogMapper = dataCleanLogMapper;
        this.dataCleanConfigMapper = dataCleanConfigMapper;
    }

    public void addLog(DataCleanLog param) {
        try {
            param.setPkId(UUID.randomUUID().toString().replaceAll("-", ""));
            param.setExeTime(new Date());
            this.dataCleanLogMapper.insertSelective(param);
        }
        catch (Exception e) {
            log.error("data clean add log error", (Throwable)e);
        }
    }

    public List<DataClean> getConfig() {
        ArrayList<DataClean> ds = new ArrayList<DataClean>();
        try {
            List<DataCleanConfig> configs = this.dataCleanConfigMapper.selectAll();
            for (DataCleanConfig config : configs) {
                DataClean t = new DataClean();
                BeanUtils.copyProperties((Object)config, (Object)t);
                ds.add(t);
            }
        }
        catch (Exception e) {
            log.error("get data clean config from db error", (Throwable)e);
        }
        return ds;
    }
}

