/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class FixByteCommOut
extends AbstractCommOut {
    protected String unitName = "Fixed length byte communication dial-out";
    private String recvLen;

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataOutputStream dos = new DataOutputStream(streamRequest.getSocketWrapper().getBos());
        try {
            if (bsend == null || bsend.length == 0) {
                throw new Exception(this.getUnitName() + " @ The variable sent is empty");
            }
            dos.write(bsend);
            this.printSendData(bsend);
            dos.flush();
        }
        catch (Exception e) {
            throw new Exception(this.getUnitName() + " @ Send data exception", e);
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataInputStream dis = new DataInputStream(streamRequest.getSocketWrapper().getBis());
        String recvStr = FixByteCommOut.getInExpressStringValue(this.recvLen, context);
        String strLen = StringTools.getString(recvStr);
        if (StringTools.isEmpty(strLen)) {
            throw new Exception("Receive length cannot be empty");
        }
        int headerLen = Integer.parseInt(strLen);
        if ((long)headerLen > 0xA00000L) {
            throw new IOException("Request too large buffer:" + headerLen + " recv failed");
        }
        byte[] data = new byte[headerLen];
        dis.readFully(data);
        this.printRecvData(data);
        return data;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public String getRecvLen() {
        return this.recvLen;
    }

    public void setRecvLen(String recvLen) {
        this.recvLen = recvLen;
    }
}

