/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import cn.com.yusys.yusp.bsp.toolkit.xml.Attribute;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SuperXMLNode {
    private String prefix = "";
    private String value = "";
    private String name;
    private String cdata = null;
    private Map<String, Attribute> attrs;
    private Map<String, Namespace> namespaces;
    private Map<String, Object> children;

    public SuperXMLNode(String name) {
        this.name = name;
        this.attrs = new HashMap<String, Attribute>();
        this.namespaces = new HashMap<String, Namespace>();
        this.children = new LinkedHashMap<String, Object>();
    }

    public String getCDATA() {
        return this.cdata;
    }

    public void setCDATA(String cdata) {
        this.cdata = cdata;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public byte[] getValue(String encoding) throws Exception {
        if (this.value == null || this.value.length() == 0) {
            return null;
        }
        return this.value.getBytes(encoding);
    }

    public byte[] getNamespaceValue(String name, String encoding) throws Exception {
        Namespace namespace = this.namespaces.get(name);
        if (namespace == null) {
            return null;
        }
        return namespace.getUri().getBytes(encoding);
    }

    public String getNamespaceValue(String name) {
        Namespace namespace = this.namespaces.get(name);
        if (namespace == null) {
            return null;
        }
        return namespace.getUri();
    }

    public byte[] getAttributeValue(String name, String encoding) throws Exception {
        Attribute attr = this.attrs.get(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue().getBytes(encoding);
    }

    public String getAttributeValue(String name) {
        Attribute attr = this.attrs.get(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public byte[] getCData(String encoding) throws Exception {
        if (this.cdata == null || this.cdata.length() == 0) {
            return null;
        }
        return this.cdata.getBytes(encoding);
    }

    public String getCData() {
        if (this.cdata == null || this.cdata.length() == 0) {
            return null;
        }
        return this.cdata;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(byte[] value, String encoding) throws Exception {
        this.value = new String(value, encoding);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void addAttrs(String name, String value) {
        Attribute attr = new Attribute(name, value);
        this.attrs.put(name, attr);
    }

    public void addAttrs(String prefix, String name, String value) {
        Attribute attr = new Attribute(prefix, name, value);
        this.attrs.put(name, attr);
    }

    public void addAttrs(Attribute attr) {
        this.attrs.put(attr.getName(), attr);
    }

    public void addNamespace(String prefix, String uri) {
        Namespace namespace = new Namespace(prefix, uri);
        this.namespaces.put(prefix, namespace);
    }

    public void addChild(SuperXMLNode child) {
        String name = child.getName();
        Object obj = this.children.get(name);
        if (obj == null) {
            this.children.put(name, child);
        } else if (obj instanceof List) {
            ((List)obj).add(child);
        } else if (obj instanceof SuperXMLNode) {
            SuperXMLNode node = (SuperXMLNode)obj;
            LinkedList<SuperXMLNode> list = new LinkedList<SuperXMLNode>();
            list.add(node);
            list.add(child);
            this.children.put(name, list);
        }
    }

    public void addChild(String name, SuperXMLNode child) {
        Object obj = this.children.get(name);
        if (obj == null) {
            this.children.put(name, child);
        } else if (obj instanceof List) {
            ((List)obj).add(child);
        } else if (obj instanceof SuperXMLNode) {
            SuperXMLNode node = (SuperXMLNode)obj;
            LinkedList<SuperXMLNode> list = new LinkedList<SuperXMLNode>();
            list.add(node);
            list.add(child);
            this.children.put(name, list);
        }
    }

    public Object getChild(String nodeName) {
        return this.children.get(nodeName);
    }

    public SuperXMLNode getChildNode(String nodeName) {
        Object obj = this.children.get(nodeName);
        if (obj instanceof SuperXMLNode) {
            return (SuperXMLNode)obj;
        }
        return null;
    }

    public List<SuperXMLNode> getChildList(String nodeName) {
        Object obj = this.children.get(nodeName);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    public void removeChild(String nodeName) {
        this.children.remove(nodeName);
    }

    public Map<String, Attribute> getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Map<String, Attribute> attrs) {
        this.attrs = attrs;
    }

    public Map<String, Namespace> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, Namespace> namespaces) {
        this.namespaces = namespaces;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getChildren() {
        return this.children;
    }

    public void setChildren(Map<String, Object> children) {
        this.children = children;
    }
}

