/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.el.ognl;

import cn.com.yusys.yusp.bsp.toolkit.el.MagicVariableFactory;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.BankitClassResolver;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.BankitObjectPropertyAccessor;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlEnhanceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ASTConst;
import ognl.ClassResolver;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public class OgnlTools {
    public static final String RESOLVED_REGION_TMP = "T_TMP";
    public static final String T_OGNL_CONTEXT = "T_OGNL_CONTEXT";
    public static final String LEFT_B = "[";
    public static final String RIGHT_B = "]";
    public static final char DOT = '.';
    public static List<String> keyword = new ArrayList<String>();
    public static final ClassResolver classResolver;
    public static final Map<String, Object> _cache;

    private static Object getParsedOgnlExpression(String expression, Map<String, Object> cache) throws Exception {
        expression = MagicVariableFactory.parseMagicExpression(expression);
        Object result = null;
        if (cache == null) {
            try {
                result = Ognl.parseExpression((String)expression);
            }
            catch (Exception e) {
                OgnlTools.checkExprKeywords(expression, e);
            }
        } else {
            result = cache.get(expression);
            if (result == null) {
                try {
                    result = Ognl.parseExpression((String)expression);
                    cache.put(expression, result);
                }
                catch (Exception e) {
                    OgnlTools.checkExprKeywords(expression, e);
                }
            }
        }
        return result;
    }

    private static void checkExprKeywords(String expression, Exception e) throws Exception {
        String foundKeyword = null;
        for (String kw : keyword) {
            if (expression.indexOf(kw) < 0) continue;
            foundKeyword = foundKeyword == null ? kw : foundKeyword + "," + kw;
        }
        if (foundKeyword != null) {
            throw new Exception("Cannot parse expression: " + expression + ", expression contains suspect key:" + foundKeyword, e);
        }
        throw new Exception("Cannot parse expression: " + expression, e);
    }

    public static Boolean getBooleanValue(String expression, Map<String, Object> context) throws Exception {
        Object object = OgnlTools.getValue(expression, context);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        if (object instanceof byte[]) {
            return Boolean.valueOf(new String((byte[])object));
        }
        return Boolean.valueOf(object.toString());
    }

    public static Object getValue(String expression, Map<String, Object> contextRoot) throws Exception {
        return OgnlTools.getValue(expression, contextRoot, _cache);
    }

    protected static Object getValue(String expression, Map<String, Object> contextRoot, Map<String, Object> cache) throws Exception {
        try {
            Object obj = contextRoot.get(expression);
            if (obj != null) {
                return obj;
            }
            Object parsedExp = OgnlTools.getParsedOgnlExpression(expression, cache);
            if (parsedExp instanceof ASTConst) {
                return ((ASTConst)parsedExp).getValue();
            }
            Object value = OgnlEnhanceUtils.getValue(expression, (Node)parsedExp, contextRoot);
            return value;
        }
        catch (OgnlException e) {
            throw new Exception("Error parsing ognl expression [" + expression + "] ", e);
        }
        catch (RuntimeException e1) {
            throw new RuntimeException("Exception parsing expression [" + expression + "] ", e1);
        }
    }

    public static void setValue(String expression, Object value, Map<String, Object> contextRoot) throws Exception {
        OgnlTools.setValue(expression, value, contextRoot, _cache);
    }

    public static void setValue(String expression, Object value, Map<String, Object> contextRoot, Map<String, Object> cache) throws Exception {
        OgnlTools.setValue(expression, value, contextRoot, cache, false);
    }

    public static void setValue(String expression, Object value, Map<String, Object> contextRoot, Map<String, Object> cache, boolean isMagic) throws Exception {
        try {
            if (!isMagic) {
                if (expression == null || expression.length() == 0) {
                    return;
                }
                if (expression.startsWith(RESOLVED_REGION_TMP)) {
                    throw new Exception("Reserved area does not allow setting value:T_TMP");
                }
            }
            Object parsedExp = OgnlTools.getParsedOgnlExpression(expression, cache);
            OgnlEnhanceUtils.setValue(expression, (Node)parsedExp, value, contextRoot);
        }
        catch (OgnlException e) {
            throw new Exception("Throw when there is an error parsing the ognl expression", e);
        }
    }

    protected static OgnlContext getOgnlContext(Map<String, Object> contextRoot) {
        Object obj = contextRoot.get(T_OGNL_CONTEXT);
        if (obj != null && obj instanceof OgnlContext) {
            return (OgnlContext)obj;
        }
        OgnlContext oc = (OgnlContext)Ognl.createDefaultContext(contextRoot);
        oc.setClassResolver(classResolver);
        contextRoot.put(T_OGNL_CONTEXT, oc);
        return oc;
    }

    public static String parseExpression(String expression, Map<String, Object> contextRoot, Map<String, Object> cache) throws Exception {
        return OgnlTools.parseExpression(expression, "${", "}", contextRoot, null, false, true);
    }

    public static String parseXPath(String xpath, Map<String, Object> contextRoot) throws Exception {
        return OgnlTools.parseExpression(xpath, LEFT_B, RIGHT_B, contextRoot, _cache, true, false);
    }

    private static String parseExpression(String expression, String startTag, String endTag, Map<String, Object> contextRoot, Map<String, Object> cache, boolean keepTag, boolean magic) throws Exception {
        if (expression == null || expression.length() == 0) {
            return expression;
        }
        try {
            StringBuilder buffer = new StringBuilder();
            int start = 0;
            int mark = expression.indexOf(startTag);
            if (mark < 0) {
                return expression;
            }
            while (mark >= 0) {
                Object value;
                buffer.append(expression.substring(start, mark));
                int markEnd = expression.indexOf(endTag, mark);
                start = markEnd + 1;
                String name = expression.substring(mark + startTag.length(), markEnd);
                if (magic && MagicVariableFactory.isMagic(name)) {
                    name = MagicVariableFactory.getMagicVariableExpression(name);
                }
                if ((value = OgnlTools.getValue(name, contextRoot, cache)) == null) {
                    throw new Exception("The value of variable [" + name + "] in expression " + expression + " is empty ");
                }
                if (keepTag) {
                    buffer.append(startTag);
                }
                buffer.append(value);
                if (keepTag) {
                    buffer.append(endTag);
                }
                mark = expression.indexOf(startTag, markEnd);
            }
            buffer.append(expression.substring(start));
            return buffer.toString();
        }
        catch (OgnlException e) {
            throw new Exception("Cannot parse expression : " + expression, e);
        }
    }

    static {
        keyword.add("in");
        keyword.add("\u201d");
        keyword.add("\u201c");
        classResolver = new BankitClassResolver();
        _cache = new ConcurrentHashMap<String, Object>();
        BankitObjectPropertyAccessor propertyAccessor = new BankitObjectPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(Object.class, (PropertyAccessor)propertyAccessor);
    }
}

