/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FileTools {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger logger = LoggerFactory.getLogger(FileTools.class);
    public static Map<String, Boolean> fileCache = new ConcurrentHashMap<String, Boolean>();

    public static List<String> recursiveListFileBySuffix(File rootFile, String filename) {
        ArrayList<String> fileList = new ArrayList<String>();
        String[] list = rootFile.list((dir, name) -> {
            String filePath = dir.getPath() + "/" + name;
            File subfile = new File(filePath);
            if (subfile.isDirectory()) {
                fileList.addAll(FileTools.recursiveListFileBySuffix(subfile, filename));
                return false;
            }
            if (name.equals(filename)) {
                fileList.add(filePath.replaceAll("\\\\", "/"));
            }
            return false;
        });
        return fileList;
    }

    public static void appendContentToFile(String fileName, byte[] content) throws Exception {
        try (FileOutputStream fos = FileTools.openOutputStream(new File(fileName), true);){
            ((OutputStream)fos).write(content, 0, content.length);
            fos.flush();
        }
    }

    public static void copyFile(String srcFile, String destFile) throws Exception {
        try (InputStream in = FileTools.openInputStream(srcFile);
             FileOutputStream out = FileTools.openOutputStream(new File(destFile));){
            FileTools.copyStream(in, out);
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
    }

    public static boolean fetchFileExists(String filePath) {
        if (ModulePath.isFileModel()) {
            File file = new File(filePath);
            return file.exists();
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource res : resources = resolver.getResources(filePath)) {
                if (!res.exists()) continue;
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public static File fetchFile(String relativePath) {
        File file = new File(relativePath);
        return file.isFile() ? file : null;
    }

    public static InputStream fetchFileStreatm(String filePath) throws Exception {
        Resource[] resources;
        if (ModulePath.isFileModel()) {
            return new FileInputStream(new File(filePath));
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource res : resources = resolver.getResources(filePath)) {
            if (!res.exists()) continue;
            return res.getInputStream();
        }
        throw new Exception("Class path resource not found:" + filePath);
    }

    public static long fetchFileLength(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("File does not exist:" + fileName);
        }
        return file.length();
    }

    public static byte[] fetchFileMd5(String fileName) throws Exception {
        byte[] bTemp = FileTools.readFileContent(fileName);
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(bTemp);
        return mdTemp.digest();
    }

    public static byte[] fetchFileMd5(File file) throws Exception {
        byte[] bTemp = FileTools.readFileContent(file);
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(bTemp);
        return mdTemp.digest();
    }

    public static byte[] fetchMd5(byte[] data) throws Exception {
        MessageDigest mdTemp = MessageDigest.getInstance("MD5");
        mdTemp.update(data);
        return mdTemp.digest();
    }

    private static void findDir(File file, String rootdir, List<String> list, String[] prefix, String[] postfix, boolean containfix) {
        String[] dirList = file.list((dir, dn) -> {
            File file1 = new File(dir + "/" + dn);
            return file1.isDirectory();
        });
        if (dirList != null) {
            for (String name : dirList) {
                String fn = rootdir.endsWith("/") ? rootdir + name : rootdir + "/" + name;
                FileTools.findFileByNamefix(fn, prefix, postfix, containfix, list);
            }
        }
    }

    private static void findFile(File file, String rootdir, List<String> list, String[] prefix, String[] postfix, boolean containfix) {
        if (!file.exists()) {
            return;
        }
        String[] fileList = file.list((dir, fn) -> {
            File file1 = new File(dir + "/" + fn);
            if (file1.isDirectory()) {
                return false;
            }
            if (containfix) {
                boolean postfixFlag = false;
                boolean prefixFlag = false;
                if (postfix != null && postfix.length > 0) {
                    for (String pf : postfix) {
                        if (!fn.endsWith(pf)) continue;
                        postfixFlag = true;
                    }
                } else {
                    postfixFlag = true;
                }
                if (prefix != null && prefix.length > 0) {
                    for (String pf : prefix) {
                        if (!fn.startsWith(pf)) continue;
                        prefixFlag = true;
                    }
                } else {
                    prefixFlag = true;
                }
                return postfixFlag && prefixFlag;
            }
            boolean postfixFlag = true;
            boolean prefixFlag = true;
            if (postfix != null && postfix.length > 0) {
                for (String pf : postfix) {
                    if (!fn.endsWith(pf)) continue;
                    postfixFlag = false;
                }
            } else {
                postfixFlag = true;
            }
            if (prefix != null && prefix.length > 0) {
                for (String pf : prefix) {
                    if (!fn.startsWith(pf)) continue;
                    prefixFlag = false;
                }
            } else {
                prefixFlag = true;
            }
            return postfixFlag || prefixFlag;
        });
        if (fileList != null) {
            for (String name : fileList) {
                String fName = rootdir.endsWith("/") ? rootdir + name : rootdir + "/" + name;
                list.add(fName);
            }
        } else {
            logger.warn("Exception getting file, path:{}", (Object)rootdir);
        }
    }

    public static String[] findFileByNamefix(String rootdir, String[] prefix, String[] postfix, boolean containfix) {
        ArrayList<String> list = new ArrayList<String>();
        FileTools.findFileByNamefix(rootdir, prefix, postfix, containfix, list);
        return list.toArray(new String[0]);
    }

    private static void findFileByNamefix(String rootdir, String[] prefix, String[] postfix, boolean containfix, List<String> list) {
        File file = new File(rootdir);
        FileTools.findFile(file, rootdir, list, prefix, postfix, containfix);
        FileTools.findDir(file, rootdir, list, prefix, postfix, containfix);
    }

    private static void getDirList(File file, List<String> list) {
        list.add(file.getPath());
        if (file.isDirectory()) {
            File[] subFile = file.listFiles();
            for (int i = 0; subFile != null && i < subFile.length; ++i) {
                FileTools.getDirList(subFile[i], list);
            }
        }
    }

    public static List<String> getAllDirList(String dir) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(dir);
        if (file.exists()) {
            FileTools.getDirList(file, list);
        }
        return list;
    }

    public static int getHexValue(byte byte1, byte byte2) {
        int num;
        if (byte2 == 32 || byte2 == 9 || byte2 == 10 || byte2 == 13 || byte2 == 12 || byte2 == -1) {
            String tmpStr = String.valueOf((char)byte1);
            num = Integer.parseInt(tmpStr, 16);
        } else {
            String tmpStr = String.valueOf((char)byte1) + (char)byte2;
            num = Integer.parseInt(tmpStr, 16);
        }
        return num;
    }

    public static InputStream openInputStream(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
            return new FileInputStream(file);
        }
        ClassPathResource resource = new ClassPathResource(fileName);
        if (!resource.exists()) {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return resource.getInputStream();
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileTools.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static File openFileDir(String dirPath) throws IOException {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            if (!dirFile.mkdirs() && !dirFile.isDirectory()) {
                throw new IOException("Directory '" + dirFile + "' could not be created");
            }
        } else if (!dirFile.isDirectory()) {
            throw new IOException("File '" + dirFile + "' exists but is not a directory");
        }
        return dirFile;
    }

    public static byte[] readFileContent(String fileName) throws IOException {
        byte[] fileContent;
        try (InputStream fis = FileTools.openInputStream(fileName);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            FileTools.copyStream(fis, baos);
            fileContent = baos.toByteArray();
        }
        return fileContent;
    }

    public static byte[] readFileContent(File file) throws IOException {
        byte[] fileContent;
        try (FileInputStream fis = FileTools.openInputStream(file);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            FileTools.copyStream(fis, baos);
            fileContent = baos.toByteArray();
        }
        return fileContent;
    }

    public static byte[] readHexFile(String fileName) throws NumberFormatException, IOException {
        byte[] result;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] hexData = FileTools.readFileContent(fileName);
            int length = hexData.length;
            for (int i = 0; i < length; ++i) {
                int frist = hexData[i] & 0xFF;
                if (!(frist >= 97 && frist <= 102 || frist >= 46 && frist <= 57) && (frist < 65 || frist > 70)) continue;
                int second = -1;
                if (length > i + 1) {
                    second = hexData[i + 1];
                }
                if (second == 9 || second == 10 || second == 13 || second == 12 || second == 32 || second == -1) {
                    out.write(Integer.parseInt(String.valueOf((char)frist), 16));
                } else {
                    out.write(Integer.parseInt(String.valueOf((char)frist) + (char)second, 16));
                }
                ++i;
            }
            result = out.toByteArray();
            out.reset();
        }
        return result;
    }

    public static Properties readPropFile(String fileName) throws Exception {
        Properties config = new Properties();
        try (InputStream in = FileTools.openInputStream(fileName);){
            config.load(in);
            Properties properties = config;
            return properties;
        }
    }

    public static void recursiveCopy(String srcFileName, String destFileName) throws Exception {
        FileTools.recursiveCopy(srcFileName, destFileName, false);
    }

    public static void recursiveCopy(String srcFileName, String destFileName, boolean filtrateSvn) throws Exception {
        File srcDir = new File(srcFileName);
        File destDir = new File(destFileName);
        if (!srcDir.isDirectory() || !srcDir.canRead()) {
            throw new Exception("Source directory must be a readable directory " + srcDir);
        }
        if (srcDir.equals(destDir)) {
            throw new Exception("Source and destination directory are the same " + srcDir);
        }
        if (!destDir.mkdirs() || !destDir.isDirectory()) {
            throw new Exception("Could not create destination directory " + destDir);
        }
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            for (File srcFile : srcFiles) {
                File destFile = new File(destDir, srcFile.getName());
                if (srcFile.isDirectory()) {
                    if (filtrateSvn && srcFile.getName().equals(".svn")) continue;
                    FileTools.recursiveCopy(srcFile.getPath(), destFile.getPath(), filtrateSvn);
                    continue;
                }
                if (!srcFile.isFile()) continue;
                FileTools.copyFile(srcFile.getPath(), destFile.getPath());
            }
        }
    }

    public static void recursiveRmFile(String fileName) throws Exception {
        File[] files;
        File root = new File(fileName);
        if (!root.exists()) {
            throw new Exception("Directory or file does not exist:" + fileName);
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileTools.recursiveRmFile(file.getPath());
                    continue;
                }
                FileTools.rmFile(file.getPath());
            }
        }
        boolean delete = root.delete();
    }

    public static boolean renameFile(String srcFile, String destFile) throws Exception {
        File sFile = new File(srcFile);
        if (!sFile.exists()) {
            throw new Exception("file does not exist:" + srcFile);
        }
        return sFile.renameTo(new File(destFile));
    }

    public static void rmFile(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("file does not exist:" + fileName);
        }
        boolean delete = file.delete();
    }

    public static void writeContentToFile(String fileName, byte[] content) throws Exception {
        try (FileOutputStream fos = FileTools.openOutputStream(new File(fileName));){
            ((OutputStream)fos).write(content, 0, content.length);
            fos.flush();
        }
    }

    public static String getMsgPath(String folderPath, String fileName) throws IOException {
        return FileChecker.getDefaultInstance().getPathInVDir(folderPath, fileName);
    }

    public static boolean isExist(String relativePath) {
        Boolean ret = fileCache.get(relativePath);
        if (ret == null) {
            boolean exists = FileTools.fetchFileExists(relativePath);
            fileCache.put(relativePath, exists);
            return exists;
        }
        return ret;
    }
}

