/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources.core;

import cn.com.yusys.yusp.bsp.resources.ResourceCreator;
import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.core.AbstractBean;
import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceHolder
extends AbstractBean {
    private final Map<String, Object> resources = new ConcurrentHashMap<String, Object>();
    private final Object resourceMute = new Object();
    private final boolean reload = Boolean.parseBoolean(System.getProperty("bsp.reload", "true"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(String fileType, String filePath) throws ResourceException {
        if (fileType == null) {
            throw new ResourceException("Illegal parameter, parameter name: fileType, parameter value is null");
        }
        if (filePath == null) {
            throw new ResourceException("Illegal parameter, parameter name: filePath, parameter value is null");
        }
        boolean needLoad = false;
        if (this.reload) {
            needLoad = FileChecker.getDefaultInstance().isChanged(filePath);
        }
        Object resourceObj = this.resources.get(filePath);
        if (needLoad || resourceObj == null) {
            Object object = this.resourceMute;
            synchronized (object) {
                resourceObj = this.resources.get(filePath);
                if ((needLoad || resourceObj == null) && (resourceObj = ResourceCreator.createResource(fileType, filePath)) != null) {
                    this.resources.put(filePath, resourceObj);
                }
            }
        }
        return resourceObj;
    }

    public void reset() {
        this.resources.clear();
    }

    public int getResourceSize() {
        return this.resources.size();
    }

    @Override
    public void doStart() {
        this.resources.clear();
    }

    @Override
    public void doStop() {
        FileChecker.getInstance(this.getBundlerId()).exit();
        this.resources.clear();
    }
}

