/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method;

import cn.com.yusys.yusp.bsp.method.FastMethodInvoker;
import cn.com.yusys.yusp.bsp.method.Utils;
import cn.com.yusys.yusp.bsp.schema.method.Method;
import cn.com.yusys.yusp.bsp.schema.method.MethodDefinition;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodRegistry {
    public static final String EP_METHOD_PACKAGE = "cn.com.yusys.yusp.bsp.method.impl.";
    private static final Map<String, Map<String, Class<?>>> _registry = new HashMap();
    private static final Map<String, Map<String, String>> registryCache = new HashMap<String, Map<String, String>>();

    public static void registryDataFormat(String domain, Class<?> clazz) {
        Map entryMap = _registry.computeIfAbsent(domain, k -> new HashMap());
        String simpleName = clazz.getName().substring(EP_METHOD_PACKAGE.length());
        entryMap.put(simpleName, clazz);
    }

    public static void registryCacheDataFormat(Method method, Class<?> clazz) {
        Map entryMap = registryCache.computeIfAbsent(method.getDomain(), k -> new HashMap());
        String simpleName = clazz.getName().substring(EP_METHOD_PACKAGE.length());
        entryMap.put(method.getMethodName(), simpleName);
    }

    public static void registryDataFormat(InputStream inputStream, Class<?> clazz, String appPath) throws Exception {
        MethodDefinition md = Utils.loadDefinitionFile(inputStream);
        MethodRegistry.registryMethodDefinition(clazz, appPath, md);
    }

    public static void registryDataFormat(File methodDefinition, Class<?> clazz, String appPath) throws Exception {
        MethodDefinition md = Utils.loadDefinitionFile(methodDefinition);
        MethodRegistry.registryMethodDefinition(clazz, appPath, md);
    }

    private static void registryMethodDefinition(Class<?> clazz, String appPath, MethodDefinition md) throws Exception {
        List<Method> ds = Utils.getAllComponent(md);
        for (Method d : ds) {
            Class<?> clazzTM = Utils.loadMethodClass(clazz.getClassLoader(), d.getClassName());
            String clazzName = clazzTM.getName();
            int index = clazzName.indexOf(EP_METHOD_PACKAGE);
            if (index == -1 || MethodRegistry.isExist(d, appPath)) continue;
            if (StringTools.isEmpty(d.getDomain()) || "plat".equals(d.getDomain())) {
                MethodRegistry.addPlatDataFormat(clazzTM);
                continue;
            }
            if ("bank".equals(d.getDomain())) {
                MethodRegistry.addBankDataFormat(clazzTM);
                continue;
            }
            throw new Exception("Illegal method domain name: [" + d.getDomain() + ":" + clazzName + "]");
        }
    }

    public static void addAppDataFormat(String appPath, Class<?> clazzTM) {
        MethodRegistry.registryDataFormat(appPath, clazzTM);
    }

    public static void addBankDataFormat(Class<?> clazzTM) {
        MethodRegistry.registryDataFormat("bank", clazzTM);
    }

    public static void addPlatDataFormat(Class<?> clazzTM) {
        MethodRegistry.registryDataFormat("plat", clazzTM);
    }

    public static void unRegistryProjMethod(String projName) {
        _registry.remove(projName);
    }

    public static void unRegistryPlatMethod(String className) {
        Map<String, Class<?>> entry = _registry.get("plat");
        if (entry != null) {
            entry.remove(className);
        }
    }

    @Deprecated
    public static Class<?> getMethod(String appPath, String domain, String name) throws Exception {
        Class<?> clazz = null;
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            clazz = MethodRegistry.getPlatMethod(name);
        } else if ("bank".equals(domain)) {
            clazz = MethodRegistry.getBankMethod(name);
        } else if ("proj".equals(domain)) {
            appPath = appPath.substring(0, appPath.indexOf("."));
            appPath = appPath + "/plugins";
            clazz = MethodRegistry.getProjMethod(appPath, name);
        } else if ("app".equals(domain)) {
            appPath = appPath.substring(0, appPath.lastIndexOf("/"));
            appPath = appPath + "/plugins";
            clazz = MethodRegistry.getProjMethod(appPath, name);
        }
        if (clazz == null) {
            throw new Exception("Method is not registered " + name);
        }
        return clazz;
    }

    public static Class<?> getMethod(String domain, String name) throws Exception {
        Class<?> clazz = null;
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            clazz = MethodRegistry.getPlatMethod(name);
        } else if ("bank".equals(domain)) {
            clazz = MethodRegistry.getBankMethod(name);
        }
        if (clazz == null) {
            if (domain == null) {
                domain = "plat";
            }
            throw new Exception(domain + ":" + name + "] is not registered");
        }
        return clazz;
    }

    private static Class<?> getProjMethod(String appPath, String name) {
        Map<String, Class<?>> entry = _registry.get(appPath);
        if (entry == null) {
            return null;
        }
        return entry.get(name);
    }

    private static Class<?> getBankMethod(String name) {
        Map<String, Class<?>> entry = _registry.get("bank");
        if (entry == null) {
            return null;
        }
        return entry.get(name);
    }

    private static Class<?> getPlatMethod(String name) {
        Map<String, Class<?>> entry = _registry.get("plat");
        if (entry == null) {
            return null;
        }
        return entry.get(name);
    }

    public static void unRegistryDataFormat(String domain, String name) {
        Map<String, Class<?>> entryMap = _registry.get(domain);
        if (entryMap != null) {
            entryMap.remove(name);
        }
    }

    public static void clearMethodCache(File methodDefinition, String appPath) throws Exception {
        MethodDefinition md = Utils.loadDefinitionFile(methodDefinition);
        List<Method> ds = Utils.getAllComponent(md);
        String clazz = "";
        for (Method d : ds) {
            if (clazz.equals(d.getClassName())) continue;
            clazz = d.getClassName();
            String className = null;
            String domain = d.getDomain();
            if (StringTools.isEmpty(domain)) {
                className = "plat:" + clazz;
            } else if ("plat".equals(domain) || "bank".equals(domain)) {
                className = domain + ":" + clazz;
            }
            FastMethodInvoker.getInstance().clear(className);
        }
    }

    public static boolean isExist(Method c, String appPath) {
        return false;
    }
}

