/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method;

import cn.com.yusys.yusp.bsp.method.MethodException;
import cn.com.yusys.yusp.bsp.method.MethodRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastMethodInvoker {
    private static final Logger logger = LoggerFactory.getLogger(FastMethodInvoker.class);
    private static final FastMethodInvoker instance = new FastMethodInvoker();
    private final Map<String, FastClass> clazzCache = new ConcurrentHashMap<String, FastClass>();
    private final Map<String, Object> clazzInstanceCache = new ConcurrentHashMap<String, Object>();
    private final Map<String, FastMethod> methodCache = new ConcurrentHashMap<String, FastMethod>();

    public static FastMethodInvoker getInstance() {
        return instance;
    }

    public void clear() {
        this.methodCache.clear();
        this.clazzCache.clear();
        this.clazzInstanceCache.clear();
    }

    public void clear(String _clazzName) {
        this.clazzCache.remove(_clazzName);
        this.clazzInstanceCache.remove(_clazzName);
        Set<String> methodKeys = this.methodCache.keySet();
        String[] methodKeysStr = new String[methodKeys.size()];
        methodKeys.toArray(methodKeysStr);
        for (String methodKey : methodKeysStr) {
            if (!methodKey.contains(_clazzName)) continue;
            this.methodCache.remove(methodKey);
            logger.info("Clear method cache\uff1a{}", (Object)methodKey);
        }
    }

    private FastClass getClazz(String domain, String clazzName) throws Exception {
        String _clazzName = null;
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            _clazzName = "plat:" + clazzName;
        } else if ("bank".equals(domain)) {
            _clazzName = domain + ":" + clazzName;
        }
        FastClass clazz = this.clazzCache.get(_clazzName);
        if (clazz == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Method call @ load class:" + _clazzName);
            }
            Class<?> clazz0 = MethodRegistry.getMethod(domain, clazzName);
            clazz = FastClass.create(clazz0);
            this.clazzCache.put(_clazzName, clazz);
            this.clazzInstanceCache.put(_clazzName, clazz.newInstance());
        }
        return clazz;
    }

    private FastMethod getMethod(FastClass clazz, String clazzName, String methodName) throws Exception {
        String key = clazzName + '@' + methodName;
        FastMethod method = this.methodCache.get(key);
        if (method == null) {
            Method[] m;
            if (logger.isDebugEnabled()) {
                logger.debug("Method calling component@ load method:" + methodName);
            }
            Class<?>[] type = null;
            for (Method value : m = clazz.getJavaClass().getMethods()) {
                if (!value.getName().equals(methodName)) continue;
                type = value.getParameterTypes();
                break;
            }
            if (type == null) {
                throw new Exception("Method does not exist:" + key);
            }
            method = clazz.getMethod(methodName, type);
            this.methodCache.put(key, method);
        }
        return method;
    }

    public Object invokeFormatMethod(String _clazzName, String _methodName, Map<String, String> paras, Object data, Map<String, Object> context) throws Exception {
        String clazzName = null;
        String domain = null;
        int index = _clazzName.indexOf(":");
        if (index != -1) {
            domain = _clazzName.substring(0, index);
            _clazzName = clazzName = _clazzName.substring(index + 1);
        }
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            clazzName = "plat:" + _clazzName;
        } else if ("bank".equals(domain)) {
            clazzName = domain + ":" + _clazzName;
        }
        FastClass fastClazz = this.getClazz(domain, _clazzName);
        FastMethod fastMethod = this.getMethod(fastClazz, clazzName, _methodName);
        Object instance = this.clazzInstanceCache.get(clazzName);
        try {
            return fastMethod.invoke(instance, new Object[]{data, paras, context});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ClassCastException) {
                throw new Exception("The input parameter type of method [" + _clazzName + "." + _methodName + "] is incorrect", e.getTargetException());
            }
            if (e.getTargetException() instanceof MethodException) {
                throw new Exception(e.getTargetException());
            }
            throw e;
        }
    }
}

