/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KVSeparatorExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "Key-Value pair separator";
    private static final String DATA_FORMAT_VALUE_TYPE = "valueType";
    private static final String DATA_FORMAT_FIRST_SIGN = "firstSign";
    private static final String DATA_FORMAT_SECOND_SIGN = "secondSign";
    private static final String DATA_FORMAT_IS_HAVE = "isHave";
    private static final String ITEM_ATTRIBUTE_VARNAME = "varName";
    private static final String IS_HAVE_LEFT = "left";
    private static final String IS_HAVE_RIGHT = "right";
    private static final String IS_HAVE_BOTH = "both";
    private byte[] firstSign;
    private byte[] secondSign;
    private boolean leftHave;
    private boolean rightHave;
    private boolean isString;
    private boolean firstPack = true;
    private ByteArrayOutputStream out;
    private Map<String, Object> dataMap;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        String attr = property.get(DATA_FORMAT_FIRST_SIGN);
        if (StringTools.isEmpty(attr)) {
            throw new Exception(this.getExecutorName() + " @ The first level separator is empty");
        }
        attr = this.parseExpressStringValue(attr);
        this.firstSign = ExecutorHelper.parserFiller(attr);
        attr = property.get(DATA_FORMAT_SECOND_SIGN);
        if (StringTools.isEmpty(attr)) {
            throw new Exception(this.getExecutorName() + " @ The second level separator is empty");
        }
        attr = this.parseExpressStringValue(attr);
        this.secondSign = ExecutorHelper.parserFiller(attr);
        attr = property.get(DATA_FORMAT_IS_HAVE);
        if (IS_HAVE_LEFT.equals(attr)) {
            this.leftHave = true;
        } else if (IS_HAVE_RIGHT.equals(attr)) {
            this.rightHave = true;
        } else if (IS_HAVE_BOTH.equals(attr)) {
            this.leftHave = true;
            this.rightHave = true;
        } else {
            this.leftHave = false;
            this.rightHave = false;
        }
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.out = new ByteArrayOutputStream();
        } else {
            attr = property.get(DATA_FORMAT_VALUE_TYPE);
            if ("string".equals(attr) && this.isAutoUnpack()) {
                this.isString = true;
            }
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        this.dataMap = this.autoUnpack(inputData);
    }

    @Override
    public byte[] outputInner() throws Exception {
        if (this.rightHave) {
            this.out.write(this.firstSign);
        }
        byte[] data = this.out.toByteArray();
        this.out.close();
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String node = paras.get(ITEM_ATTRIBUTE_VARNAME);
        if (StringUtils.isEmpty((CharSequence)node)) {
            node = item.getName();
        }
        if (this.firstPack) {
            this.firstPack = false;
            if (this.leftHave) {
                this.out.write(this.firstSign);
            }
        } else {
            this.out.write(this.firstSign);
        }
        this.out.write(node.getBytes(this.getEncoding()));
        this.out.write(this.secondSign);
        this.out.write(data);
    }

    @Override
    public byte[] autoPack(Map<String, Object> map) throws Exception {
        byte[] data;
        if (this.leftHave) {
            this.out.write(this.firstSign);
        }
        boolean bool = false;
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (this.isSimpleType(obj)) {
                data = ByteTools.getBytes(obj, this.getEncoding());
                if (this.isFilterEmpty() && data.length == 0) {
                    this.logger.debug("{} @ Auto packaging: {}, filter empty string", new Object[]{this.getExecutorName(), key});
                    continue;
                }
                data = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), data, 1);
                if (bool) {
                    this.out.write(this.firstSign);
                } else {
                    bool = true;
                }
                this.out.write(key.getBytes(this.getEncoding()));
                this.out.write(this.secondSign);
                this.out.write(data);
                this.logger.debug("{} @ Auto packing: {}=[{}]", new Object[]{this.getExecutorName(), key, StringTools.getString(obj, this.getEncoding())});
                continue;
            }
            if (obj != null) {
                this.logger.warn("{} @ Auto packing: {}, type [{}] is not supported", new Object[]{this.getExecutorName(), key, obj.getClass().getName()});
                continue;
            }
            this.logger.warn("{} @ Auto packing: {}, ignore(value is null)", new Object[]{this.getExecutorName(), key});
        }
        if (this.rightHave) {
            this.out.write(this.firstSign);
        }
        data = this.out.toByteArray();
        this.out.close();
        return data;
    }

    @Override
    public Map<String, Object> autoUnpack() {
        return this.dataMap;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String node = paras.get(ITEM_ATTRIBUTE_VARNAME);
        if (StringUtils.isEmpty((CharSequence)node)) {
            node = item.getName();
        }
        return ByteTools.getBytes(this.dataMap.get(node), this.getEncoding());
    }

    private Map<String, Object> autoUnpack(byte[] data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int index = 0;
        if (this.leftHave) {
            index += this.firstSign.length;
        }
        this.parserData(map, data, index);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parserData(Map<String, Object> map, byte[] data, int index) {
        while (index <= data.length) {
            int pos = ExecutorHelper.searchSeparatorPosition(index, data, this.firstSign, this.getEncoding());
            int len = pos - index;
            byte[] datacopy = new byte[len];
            System.arraycopy(data, index, datacopy, 0, len);
            try {
                int poscopy = ExecutorHelper.searchSeparatorPosition(0, datacopy, this.secondSign, this.getEncoding());
                byte[] key = new byte[poscopy];
                if (key.length == 0) continue;
                System.arraycopy(datacopy, 0, key, 0, poscopy);
                int indexcopy = poscopy + this.secondSign.length;
                int lencopy = len - indexcopy;
                byte[] value = new byte[lencopy];
                System.arraycopy(datacopy, indexcopy, value, 0, lencopy);
                value = (byte[])this.invokeMethods(this.getGlobalParseMethod(), value, 1);
                if (value == null || value.length == 0) continue;
                String keyStr = new String(key, this.getEncoding());
                Object obj = map.get(keyStr);
                if (obj == null) {
                    if (this.isString) {
                        map.put(new String(key, this.getEncoding()), new String(value, this.getEncoding()));
                    } else {
                        map.put(new String(key, this.getEncoding()), value);
                    }
                }
                if (obj instanceof String || obj instanceof byte[]) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(map.remove(keyStr));
                    if (this.isString) {
                        list.add(new String(value, this.getEncoding()));
                    } else {
                        list.add(value);
                    }
                    map.put(keyStr, list);
                }
                if (!(obj instanceof List)) continue;
                if (this.isString) {
                    ((List)obj).add(new String(value, this.getEncoding()));
                    continue;
                }
                ((List)obj).add(value);
            }
            catch (Exception exception) {}
            continue;
            finally {
                index = pos + this.firstSign.length;
            }
        }
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

