/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.out;

import cn.com.yusys.yusp.bsp.communication.AbstractAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.out.IOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public abstract class AbstractOutAdapter
extends AbstractAdapter
implements IOutAdapter {
    private String adapterName;
    private Semaphore acquire;
    private int maxConcurrent = -1;
    protected Map<String, IRequest> usedRequest = new ConcurrentHashMap<String, IRequest>();
    private static final String REGEX_IP = "(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";

    public String getAdapterName() {
        if (this.adapterName == null) {
            this.adapterName = this.getAdapterTypeName() + "[" + this.getBeanName() + "]";
        }
        return this.adapterName;
    }

    @Override
    public int getAdapterType() {
        return 1;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (this.maxConcurrent > 0) {
            this.acquire = new Semaphore(this.maxConcurrent, true);
        }
    }

    @Override
    public void doStop() throws Exception {
        Iterator<IRequest> iter = this.getUsedRequest().values().iterator();
        try {
            while (iter.hasNext()) {
                IRequest req = iter.next();
                req.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getUsedRequest().clear();
        if (this.acquire != null) {
            this.acquire.drainPermits();
        }
    }

    @Override
    public IRequest borrowRequest(Session session) throws Exception {
        SocketWrapper wrapper;
        Object object;
        IRequest request = this.getUsedRequest().get(session.getSessionId());
        if (request == null) {
            if (this.acquire != null) {
                this.acquire.acquire();
            }
            request = this.makeRequest(session);
            request.setSessionId(session.getSessionId());
            this.getUsedRequest().put(session.getSessionId(), request);
            session.getOutRequests().add(request);
            object = request.getDatasourceWrapper();
            if (object instanceof SocketWrapper) {
                wrapper = (SocketWrapper)object;
                wrapper.setSessionId(session.getSessionId());
            }
        }
        if (request instanceof StreamRequest) {
            ((StreamRequest)request).setLastUsedTime(System.currentTimeMillis());
            object = request.getDatasourceWrapper();
            if (object instanceof SocketWrapper) {
                wrapper = (SocketWrapper)object;
                wrapper.setLastUsedTime(System.currentTimeMillis());
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnRequest(IRequest request) throws Exception {
        IRequest req;
        String sessionId = request.getSessionId();
        if (sessionId != null && (req = this.getUsedRequest().remove(sessionId)) != null) {
            try {
                this.unmakeRequest(request);
                req.setSessionId(null);
                if (req.getDatasourceWrapper() instanceof SocketWrapper) {
                    SocketWrapper wrapper = (SocketWrapper)req.getDatasourceWrapper();
                    wrapper.setSessionId(null);
                }
            }
            finally {
                if (this.acquire != null) {
                    this.acquire.release();
                }
            }
        }
    }

    protected abstract IRequest makeRequest(Session var1) throws Exception;

    protected abstract void unmakeRequest(IRequest var1) throws Exception;

    public Map<String, IRequest> getUsedRequest() {
        return this.usedRequest;
    }

    public void setUsedRequest(Map<String, IRequest> usedRequest) {
        this.usedRequest = usedRequest;
    }

    public boolean isAvalible(IRequest request) {
        StreamRequest requestStream = (StreamRequest)request;
        return !requestStream.needToClose();
    }

    public boolean validateIP(String ip) {
        if (ip == null || ip.length() == 0) {
            return false;
        }
        return ip.matches(REGEX_IP);
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public void setMaxConcurrent(int maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
    }

    public void setAdapterName(String adapterName) {
        this.adapterName = adapterName;
    }
}

