/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModulePath {
    public static final String CONFIG_FROM_FILE = "file";
    private static final String CONFIG_PATH = "config";
    public static final String MODULE_MRD = "module.mrd";
    public static final String SEARCH_FOR_MODULE_MRD = "/module.mrd";
    public static final String CLASS_PATH = "classpath*:";
    private static final String CONFIG_CPATH = "classpath*:config";
    public static final String CONFIGURATION_CPATH = "*/*/module.mrd";
    private static String model;
    private static String configPath;
    private static Map<String, String> modulePathCache;

    public static String getModulePath() {
        if (ModulePath.isFileModel()) {
            if (configPath != null && configPath.length() != 0) {
                return configPath;
            }
            return CONFIG_PATH;
        }
        return CONFIG_CPATH;
    }

    public static String getModulePath(String moduleName, boolean appendFilename) {
        String modulePath = modulePathCache.get(moduleName);
        if (modulePath == null) {
            modulePath = ModulePath.getModulePath();
            if (!modulePath.endsWith("/")) {
                modulePath = modulePath + "/";
            }
            modulePath = modulePath + moduleName.replaceAll("\\.", "/");
            modulePathCache.putIfAbsent(moduleName, modulePath);
        }
        if (appendFilename) {
            modulePath = modulePath + SEARCH_FOR_MODULE_MRD;
        }
        return modulePath;
    }

    public static boolean isFileModel() {
        return ModulePath.isFileModel(model);
    }

    public static boolean isFileModel(String model) {
        return CONFIG_FROM_FILE.equalsIgnoreCase(model);
    }

    public static String getModel() {
        return model;
    }

    static void setModel(String model) {
        ModulePath.model = model;
    }

    static void setConfigPath(String configPath) {
        ModulePath.configPath = configPath;
    }

    static {
        modulePathCache = new ConcurrentHashMap<String, String>();
    }
}

