/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.app.config.ServiceEntityManager;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.workflow.BspController;
import cn.com.yusys.yusp.bsp.workflow.TradeMapping;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AppStartAssist {
    private static final Logger logger = LoggerFactory.getLogger(AppStartAssist.class);
    private static final SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();
    private static final Set<String> MODULE_CACHE = new CopyOnWriteArraySet<String>();

    public static void startModule() throws Exception {
        try {
            Object[] reses;
            String[] array;
            for (String s : array = BspBoot.applicationContext.getBeanNamesForAnnotation(BspController.class)) {
                Method[] methods;
                Object obean = BspBoot.applicationContext.getBean(s);
                BspController controller = obean.getClass().getAnnotation(BspController.class);
                String moduleName = controller.moduleName();
                if ("".equals(moduleName)) {
                    moduleName = controller.value();
                }
                for (Method method : methods = obean.getClass().getDeclaredMethods()) {
                    TradeMapping tradeMapping = method.getAnnotation(TradeMapping.class);
                    if (tradeMapping == null) continue;
                    String value = tradeMapping.value();
                    String code = tradeMapping.code();
                    if (code.isEmpty()) {
                        code = value;
                    }
                    Class<?> paraClazz = method.getParameterTypes()[0];
                    Class<?> retType = method.getReturnType();
                    ServiceEntity entity = new ServiceEntity();
                    entity.setCode(code);
                    entity.setValue(value);
                    entity.setParaType(paraClazz);
                    entity.setRetType(retType);
                    Type[] genericParameterTypes = method.getGenericParameterTypes();
                    if (genericParameterTypes.length > 0) {
                        entity.setParameterType(genericParameterTypes[0]);
                    }
                    entity.setReturnType(method.getGenericReturnType());
                    entity.setMethod(method);
                    entity.setBean(obean);
                    ServiceEntityManager.putServiceEntity(moduleName, value, entity);
                }
            }
            String path = ModulePath.getModulePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String locationPattern = path + "*/*/module.mrd";
            logger.info("Load communication configuration[{}]", (Object)locationPattern);
            String threadName = Thread.currentThread().getName();
            if (ModulePath.isFileModel()) {
                File rootFile = new File(path);
                for (Resource res : reses = FileTools.recursiveListFileBySuffix(rootFile, "module.mrd").toArray(new String[0])) {
                    AppStartAssist.loadModule(new File((String)res).toURI().toString());
                }
            } else {
                PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
                for (Resource res : reses = pmrpr.getResources(locationPattern)) {
                    AppStartAssist.loadModule(res.getURL().toString());
                }
            }
            Thread.currentThread().setName(threadName);
            logger.info("Load communication configuration successfully!");
        }
        catch (Exception e) {
            logger.error("Failed to load communication configuration :", (Throwable)e);
            throw e;
        }
    }

    public static void loadModule(String modulePath) {
        BspAppContext xc = new BspAppContext(new String[]{modulePath}, false, BspBoot.applicationContext);
        try {
            String serviceName = AppStartAssist.fetchService(modulePath);
            Thread.currentThread().setName(serviceName);
            logger.info("Load service name[{}] configuration", (Object)serviceName);
            xc.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)BspBoot.applicationContext.getBean("customEditorConfigurer"));
            xc.refresh();
            _contextRegistry.addAppContext(serviceName, xc);
            AppStartAssist.addModule(serviceName);
        }
        catch (Exception e) {
            logger.error("module start fail:" + modulePath, (Throwable)e);
            xc.close();
        }
    }

    public static List<String> getStartModules() {
        return new ArrayList<String>(MODULE_CACHE);
    }

    public static void addModule(String moduleName) {
        MODULE_CACHE.add(moduleName);
    }

    public static void removeModule(String moduleName) {
        MODULE_CACHE.remove(moduleName);
    }

    private static String fetchService(String path) {
        int index = path.indexOf("config/comm");
        int startIndex = path.indexOf("/", index);
        int endIndex = path.indexOf("/module.mrd", startIndex);
        return path.substring(startIndex + 1, endIndex).replaceAll("/", ".");
    }

    public static void stopModule() {
        Collection<BspAppContext> contextSet = _contextRegistry.getContextMap().values();
        for (BspAppContext bspAppContext : contextSet) {
            bspAppContext.close();
        }
    }
}

