/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fuzzy;

import cn.com.yusys.yusp.commons.fuzzy.FuzzySearchIn;
import cn.com.yusys.yusp.commons.fuzzy.FuzzySearchOut;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public abstract class FuzzyDataLoadHelper
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(FuzzyDataLoadHelper.class);
    private static final String FIELD_TYPE_NAME = "name";
    private static final String FIELD_TYPE_EXT1 = "ext1";
    private static final String FIELD_TYPE_EXT2 = "ext2";
    private final Object lockObject = new Object();
    private long nextLoadTime = 0L;
    private List<FuzzySearchOut> cache = null;

    public boolean needPreLoad() {
        return true;
    }

    public long cacheTime() {
        return 10L;
    }

    public List<FuzzySearchOut> searchData(FuzzySearchIn in) {
        List<FuzzySearchOut> result = null;
        if (this.needReload()) {
            long stratTime = this.getCurrentTimeMillis();
            this.cache = this.getData();
            long time = this.getCurrentTimeMillis() - stratTime;
            log.info("reload data success,time:{}ms", (Object)time);
        }
        if (null == this.cache) {
            result = new ArrayList<FuzzySearchOut>(0);
        } else {
            Integer num = in.getSearchCnt();
            String filedName = in.getSearchField();
            String param = in.getSearchInput();
            if (null == num || 0 == num) {
                if (FIELD_TYPE_NAME.equals(filedName)) {
                    result = this.cache.stream().filter(p -> p.getSearchReturnName().contains(param)).collect(Collectors.toList());
                    result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnName));
                } else if (FIELD_TYPE_EXT1.equals(filedName)) {
                    result = this.cache.stream().filter(p -> p.getReserveField1().contains(param)).collect(Collectors.toList());
                    result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnName));
                } else if (FIELD_TYPE_EXT2.equals(filedName)) {
                    result = this.cache.stream().filter(p -> p.getReserveField2().contains(param)).collect(Collectors.toList());
                    result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnName));
                } else {
                    result = this.cache.stream().filter(p -> p.getSearchReturnCode().contains(param)).collect(Collectors.toList());
                    result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnCode));
                }
            } else if (FIELD_TYPE_NAME.equals(filedName)) {
                result = this.cache.stream().filter(p -> p.getSearchReturnName().contains(param)).limit(num.intValue()).collect(Collectors.toList());
                result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnName));
            } else if (FIELD_TYPE_EXT1.equals(filedName)) {
                result = this.cache.stream().filter(p -> p.getReserveField1().contains(param)).limit(num.intValue()).collect(Collectors.toList());
                result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnName));
            } else if (FIELD_TYPE_EXT2.equals(filedName)) {
                result = this.cache.stream().filter(p -> p.getReserveField2().contains(param)).limit(num.intValue()).collect(Collectors.toList());
                result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnName));
            } else {
                result = this.cache.stream().filter(p -> p.getSearchReturnCode().contains(param)).limit(num.intValue()).collect(Collectors.toList());
                result.sort(Comparator.comparing(FuzzySearchOut::getSearchReturnCode));
            }
        }
        return result;
    }

    public abstract List<FuzzySearchOut> getData();

    public List<FuzzySearchOut> getCacheData() {
        if (this.needReload()) {
            this.cache = this.getData();
        }
        return this.cache;
    }

    public abstract String getDataName();

    public void run(ApplicationArguments args) throws Exception {
        try {
            if (this.needPreLoad()) {
                long stratTime = this.getCurrentTimeMillis();
                this.cache = this.getData();
                this.nextLoadTime = this.getCurrentTimeMillis() + this.cacheTime() * 60L * 1000L;
                long time = this.getCurrentTimeMillis() - stratTime;
                int num = this.cache == null ? 0 : this.cache.size();
                log.info("preload data success ,name:{},size:{},time:{}ms", new Object[]{this.getDataName(), num, time});
            }
        }
        catch (Exception e) {
            log.error("preload data failed", (Throwable)e);
        }
    }

    private long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needReload() {
        Object object = this.lockObject;
        synchronized (object) {
            long currentTime = this.getCurrentTimeMillis();
            if (this.nextLoadTime < currentTime) {
                this.nextLoadTime = this.getCurrentTimeMillis() + this.cacheTime() * 60L * 1000L;
                return true;
            }
            return false;
        }
    }
}

