/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.biz.adapter;

import cn.com.yusys.yusp.commons.biz.BizInterceptorContext;
import cn.com.yusys.yusp.commons.biz.BizMvcHandlerInterceptor;
import cn.com.yusys.yusp.commons.biz.InterceptorType;
import cn.com.yusys.yusp.commons.biz.adapter.DefaultError;
import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class DefaultBizMvcHandlerInterceptor
implements BizMvcHandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBizMvcHandlerInterceptor.class);
    private final String defaultErrorCode;

    public DefaultBizMvcHandlerInterceptor(String defaultErrorCode) {
        this.defaultErrorCode = defaultErrorCode;
    }

    @Override
    public String type() {
        return "error";
    }

    @Override
    public InterceptorType interceptorType() {
        return InterceptorType.EXCEPTION_HANDLER;
    }

    @Override
    public <T> T run() {
        if (!BizInterceptorContext.currentContext().containsKey("exceptionHandlerResult")) {
            Exception exception = (Exception)BizInterceptorContext.currentContext().get("exceptionHandlerException");
            logger.error(exception.getMessage(), (Throwable)exception);
            HandlerMethod handlerMethod = (HandlerMethod)BizInterceptorContext.currentContext().get("exceptionHandlerMethod");
            if (handlerMethod.getReturnType().getParameterType().isAssignableFrom(ResultDto.class)) {
                String errorCode = (String)ReflectionUtils.getPropertyValue((Object)exception, (String)"errorCode");
                ResultDto resultDto = ResultDto.error(StringUtils.nonEmpty((CharSequence)errorCode) ? errorCode : this.defaultErrorCode, StringUtils.substring((String)exception.getMessage(), (int)0, (int)100));
                BizInterceptorContext.currentContext().put("exceptionHandlerResult", resultDto);
            } else {
                BizInterceptorContext.currentContext().put("exceptionHandlerResult", DefaultError.builder().error(handlerMethod.getShortLogMessage()).message(exception.getMessage()).path(handlerMethod.getMethod().toString()).timestamp(DateUtils.formatDateTimeByDef()).build());
            }
        }
        return null;
    }
}

