/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.standard.impl;

import cn.com.yusys.yusp.commons.core.FactoryObjects;
import cn.com.yusys.yusp.commons.util.Asserts;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class AbstractEnumClassFactoryObjects<T>
implements FactoryObjects<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEnumClassFactoryObjects.class);
    private final List<String> packages;
    private final ResourcePatternResolver resolver;
    private final MetadataReaderFactory metadataReaderFactory;

    public AbstractEnumClassFactoryObjects(ResourceLoader resourceLoader, List<String> packages) {
        Asserts.nonEmpty(packages, (Object[])new Object[]{"Package path must not empty!"});
        this.packages = packages;
        this.resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public <R> Set<Class<? extends R>> scan(Class<R> classType) {
        return this.packages.stream().map(p -> this.doScan((String)p, classType)).filter(Objects::nonNull).flatMap(Collection::stream).filter(Class::isEnum).collect(Collectors.toSet());
    }

    public <R> Set<Class<? extends R>> doScan(String scanPath, Class<R> classType) {
        try {
            return this.doScan0(scanPath, classType);
        }
        catch (IOException e) {
            logger.error("Current path:[{}] scan occur exception! cause by:{}", (Object)scanPath, (Object)e.getMessage());
            return null;
        }
    }

    public <R> Set<Class<? extends R>> doScan0(String scanPath, Class<R> classType) throws IOException {
        Resource[] resources;
        HashSet<Class<R>> classes = new HashSet<Class<R>>();
        String packageSearchPath = "classpath*:".concat(ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)scanPath)).concat("/**/*.class"));
        for (Resource resource : resources = this.resolver.getResources(packageSearchPath)) {
            if (!resource.isReadable()) continue;
            MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
            try {
                if (!metadataReader.getClassMetadata().isConcrete()) continue;
                classes.add(Class.forName(metadataReader.getClassMetadata().getClassName()).asSubclass(classType));
            }
            catch (Exception e) {
                logger.error("Current path:[{}] scan occur exception! cause by:{}", (Object)scanPath, (Object)e.getMessage());
            }
        }
        return classes;
    }
}

