/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.standard.impl;

import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.DictItem;
import cn.com.yusys.yusp.commons.module.standard.FactoryDict;
import cn.com.yusys.yusp.commons.module.standard.impl.AbstractEnumClassFactoryObjects;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;

public class EnumClassFactoryDict
extends AbstractEnumClassFactoryObjects<Dict>
implements FactoryDict {
    private static final Logger logger = LoggerFactory.getLogger(EnumClassFactoryDict.class);

    public EnumClassFactoryDict(ResourceLoader resourceLoader, List<String> packages) {
        super(resourceLoader, packages);
    }

    @Override
    public List<Dict> getObjects() {
        Set<Class<DictItem>> classSet = this.scan(DictItem.class);
        LinkedList<Dict> dicts = new LinkedList<Dict>();
        for (Class<DictItem> dictItemClass : classSet) {
            Object[] dictItems = dictItemClass.getEnumConstants();
            if (ArrayUtils.nonEmpty((Object[])dictItems)) {
                dicts.add(new EnumDict((DictItem[])dictItems));
                continue;
            }
            logger.warn("Current enum class[{}] not exist enum constants!", (Object)dictItemClass.getName());
        }
        return dicts;
    }

    static class EnumDict
    implements Dict {
        DictItem[] items;

        public EnumDict(DictItem[] items) {
            this.items = items;
        }

        @Override
        public String dictCode() {
            return this.items[0].dictCode();
        }

        @Override
        public String dictName(Locale locale) {
            return this.items[0].dictName(locale);
        }

        @Override
        public DictItem[] items() {
            return this.items;
        }
    }
}

