/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fuzzy;

import cn.com.yusys.yusp.commons.fuzzy.FuzzySearchIn;
import cn.com.yusys.yusp.commons.fuzzy.FuzzySearchOut;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public abstract class FuzzyDataLoadHelper
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(FuzzyDataLoadHelper.class);
    private long nextLoadTime = 0L;
    private List<FuzzySearchOut> cache = null;
    private static final String FIELD_TYPE_NAME = "name";

    public boolean needPreLoad() {
        return true;
    }

    public long cacheTime() {
        return 10L;
    }

    public List<FuzzySearchOut> searchData(FuzzySearchIn in) {
        List<FuzzySearchOut> result = null;
        if (this.needReload()) {
            this.cache = this.getData();
        }
        if (null == this.cache) {
            result = new ArrayList<FuzzySearchOut>(0);
        } else {
            Integer num = in.getSearchCnt();
            String filedName = in.getSearchField();
            String param = in.getSearchInput();
            result = null == num || 0 == num ? (FIELD_TYPE_NAME.equals(filedName) ? this.cache.stream().filter(p -> p.getSearchReturnName().indexOf(param) > -1).collect(Collectors.toList()) : this.cache.stream().filter(p -> p.getSearchReturnCode().indexOf(param) > -1).collect(Collectors.toList())) : (FIELD_TYPE_NAME.equals(filedName) ? this.cache.stream().filter(p -> p.getSearchReturnName().indexOf(param) > -1).limit(num.intValue()).collect(Collectors.toList()) : this.cache.stream().filter(p -> p.getSearchReturnCode().indexOf(param) > -1).limit(num.intValue()).collect(Collectors.toList()));
        }
        return result;
    }

    public abstract List<FuzzySearchOut> getData();

    public List<FuzzySearchOut> getCacheData() {
        if (this.needReload()) {
            this.cache = this.getData();
        }
        return this.cache;
    }

    public abstract String getDataName();

    public void run(ApplicationArguments args) throws Exception {
        try {
            if (this.needPreLoad()) {
                long stratTime = this.getCurrentTimeMillis();
                this.cache = this.getData();
                this.nextLoadTime = this.getCurrentTimeMillis() + this.cacheTime() * 60L * 1000L;
                long time = this.getCurrentTimeMillis() - stratTime;
                int num = this.cache == null ? 0 : this.cache.size();
                log.info("preload data success ,name:{},size:{},time:{}ms", new Object[]{this.getDataName(), num, time});
            }
        }
        catch (Exception e) {
            log.error("preload data failed", (Throwable)e);
        }
    }

    private long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    private synchronized boolean needReload() {
        long currentTime = this.getCurrentTimeMillis();
        if (this.nextLoadTime < currentTime) {
            this.nextLoadTime = this.getCurrentTimeMillis() + this.cacheTime();
            return true;
        }
        return false;
    }
}

