/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.swagger;

import cn.com.yusys.yusp.commons.autoconfigure.swagger.SwaggerProperties;
import cn.com.yusys.yusp.commons.swagger.config.SwaggerConfigurer;
import cn.com.yusys.yusp.commons.swagger.constant.ApiModel;
import cn.com.yusys.yusp.commons.swagger.util.RequestMatcherUtils;
import cn.com.yusys.yusp.commons.swagger.web.SwaggerDashboardController;
import cn.com.yusys.yusp.commons.util.Predicates;
import cn.com.yusys.yusp.commons.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiResourceController;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConditionalOnClass(value={ApiResourceController.class, SwaggerDashboardController.class})
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class YuSwaggerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YuSwaggerAutoConfiguration.class);
    private final SwaggerProperties swaggerProperties;
    private final Environment environment;

    public YuSwaggerAutoConfiguration(SwaggerProperties swaggerProperties, Environment environment) {
        this.swaggerProperties = swaggerProperties;
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean
    public UiConfiguration uiConfiguration(ObjectProvider<List<SwaggerConfigurer>> configurerProvider) {
        SwaggerProperties.Ui ui = this.swaggerProperties.getUi();
        String version = StringUtils.isBlank((CharSequence)ui.getValidatorUrl()) ? "" : (!ui.getValidatorUrl().contains("?") ? "?" : "&") + "version=" + ui.getVersion();
        UiConfigurationBuilder builder = UiConfigurationBuilder.builder().validatorUrl(ui.getValidatorUrl() + version).supportedSubmitMethods(ui.getSupportedSubmitMethods());
        List swaggerConfigurerList = (List)configurerProvider.getIfAvailable();
        if (swaggerConfigurerList != null && !swaggerConfigurerList.isEmpty()) {
            swaggerConfigurerList.forEach(swaggerConfigurer -> swaggerConfigurer.configure(builder));
        }
        if (this.environment.containsProperty("yusp.swagger.ui.gateway")) {
            builder.showExtensions((Boolean)this.environment.getProperty("yusp.swagger.ui.gateway", Boolean.class));
        }
        log.debug("Load swagger ui configuration competed");
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket docket(SwaggerProperties swaggerProperties) {
        log.debug("loading Swagger api configuration");
        StopWatch watch = new StopWatch();
        watch.start();
        SwaggerProperties.Api api = swaggerProperties.getApi();
        Contact contact = this.contact(api);
        ApiInfo apiInfo = this.apiInfo(api, contact);
        Docket docket = this.docket(apiInfo, api);
        watch.stop();
        log.debug("Loaded swagger configuration in {} ms", (Object)watch.getTotalTimeMillis());
        return docket;
    }

    private Docket docket(ApiInfo apiInfo, SwaggerProperties.Api api) {
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        docket.apiInfo(apiInfo);
        docket.forCodeGeneration(true);
        docket.directModelSubstitute(ByteBuffer.class, String.class);
        docket.genericModelSubstitutes(new Class[]{ResponseEntity.class});
        ApiSelectorBuilder apiSelectorBuilder = docket.select();
        this.configureApiSelectorRules(apiSelectorBuilder, api);
        return docket;
    }

    private void configureApiSelectorRules(ApiSelectorBuilder builder, SwaggerProperties.Api api) {
        builder.apis(RequestHandlerSelectors.any());
        Optional pathOptional = RequestMatcherUtils.pathPredicate((String)api.getPaths());
        pathOptional.ifPresent(arg_0 -> ((ApiSelectorBuilder)builder).paths(arg_0));
        ApiModel model = api.getModel();
        if (ApiModel.PLAIN.equals((Object)model)) {
            builder.apis(Predicates.or((Predicate[])new Predicate[]{RequestHandlerSelectors.withClassAnnotation(Api.class), RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)}));
        }
        builder.build();
    }

    private Contact contact(SwaggerProperties.Api api) {
        return new Contact(api.getContactName(), api.getContactUrl(), api.getContactEmail());
    }

    private ApiInfo apiInfo(SwaggerProperties.Api api, Contact contact) {
        return new ApiInfoBuilder().contact(contact).title(api.getTitle()).description(api.getDescription()).version(api.getVersion()).license(api.getLicense()).licenseUrl(api.getLicenseUrl()).termsOfServiceUrl(api.getTermsOfServiceUrl()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public SwaggerDashboardController dashboardController() {
        log.debug("Load swagger dashboard page");
        return new SwaggerDashboardController();
    }
}

