/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperMybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import cn.com.yusys.yusp.commons.mapper.executor.SqlSessionExecutor;
import cn.com.yusys.yusp.commons.mapper.sql.DefaultSqlHelper;
import cn.com.yusys.yusp.commons.mapper.sql.SqlHelper;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import tk.mybatis.mapper.entity.Config;

@ConditionalOnClass(value={SqlExecutor.class, SqlHelper.class})
@AutoConfigureAfter(value={MapperMybatisAutoConfiguration.class})
public class MapperConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MapperConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={SqlExecutor.class})
    public SqlExecutor sqlSessionExecutor(SqlSession sqlSession, SqlSessionFactory sqlSessionFactory) {
        log.debug("load default SqlExecutor: SqlSessionExecutor");
        SqlSessionExecutor sqlSessionExecutor = new SqlSessionExecutor(sqlSession);
        sqlSessionExecutor.setSqlSessionFactory(sqlSessionFactory);
        return sqlSessionExecutor;
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlHelper.class})
    public SqlHelper defaultSqlHelper(SqlSession sqlSession, Config config) {
        log.debug("load default sqlHelper\uff1aDefaultSqlHelper");
        return new DefaultSqlHelper(sqlSession.getConfiguration(), config);
    }
}

