/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.logging;

import ch.qos.logback.classic.Logger;
import cn.com.yusys.yusp.commons.log.trace.TraceLogger;
import cn.com.yusys.yusp.commons.mybatis.logger.SqlLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

@ConditionalOnClass(value={TraceLogger.class})
public class MonitorLogbackDynamicPrinter
implements ApplicationListener<EnvironmentChangeEvent>,
EnvironmentAware {
    private static final Map<String, Logger> DYNAMIC_OUT_APP_LOGGERS = new HashMap<String, Logger>();
    private Environment environment;

    public static void addLogger(String key, Logger logger) {
        DYNAMIC_OUT_APP_LOGGERS.put(key, logger);
    }

    public void onApplicationEvent(@NonNull EnvironmentChangeEvent event) {
        Set keys = event.getKeys();
        keys.forEach(key -> {
            Logger log = DYNAMIC_OUT_APP_LOGGERS.get(key);
            if (Objects.nonNull(log)) {
                log.setAdditive(((Boolean)this.environment.getProperty(key, Boolean.class, (Object)true)).booleanValue());
            }
        });
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
        DYNAMIC_OUT_APP_LOGGERS.put("yusp.biz.sql-log.enabled", (Logger)LoggerFactory.getLogger(SqlLogger.class));
    }
}

