/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileClientRegister;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusMapperScanAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperMybatisMapperScanAutoConfiguration;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsConfig;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileClient;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileSystemTemplate;
import cn.com.yusys.yusp.commons.file.client.fastdfs.mapper.FileFolderInfoMapper;
import cn.com.yusys.yusp.commons.file.client.fastdfs.mapper.FileInfoMapper;
import cn.com.yusys.yusp.commons.file.client.fastdfs.service.FastDfsCommandService;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={ConnectConfig.class, FastDfsFileClient.class})
@AutoConfigureBefore(value={FileAutoConfiguration.class})
public class FastDfsFileAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={MapperScanBasePackage.class})
    public MapperScanBasePackage fileMapperPath() {
        return () -> Collections.singletonList("cn.com.yusys.yusp.commons.file.client.fastdfs.mapper");
    }

    @Configuration
    @ConditionalOnClass(value={ConnectConfig.class, FastDfsFileClient.class})
    @AutoConfigureBefore(value={FileAutoConfiguration.class})
    @AutoConfigureAfter(value={MapperMybatisMapperScanAutoConfiguration.class, MybatisPlusMapperScanAutoConfiguration.class})
    static class FastDfsFileClientAutoConfiguration {
        private static final String FAST_DFS_COMMAND_SERVICE_BEAN_NAME = "fastDfsCommandService";

        FastDfsFileClientAutoConfiguration() {
        }

        @Bean(name={"fastDfsCommandService"})
        public FastDfsCommandService fastDfsCommandService(ObjectProvider<FileFolderInfoMapper> fileFolderInfoMapper, ObjectProvider<FileInfoMapper> fileInfoMapper) {
            return new FastDfsCommandService((FileFolderInfoMapper)fileFolderInfoMapper.getIfAvailable(), (FileInfoMapper)fileInfoMapper.getIfAvailable());
        }

        @Bean
        public FileSystemTemplateRegister fastDfsFileSystemTemplateRegister() {
            return fileClient -> fileClient instanceof FastDfsFileClient ? new FastDfsFileSystemTemplate((FastDfsFileClient)fileClient) : null;
        }

        @Bean
        public FileClientRegister fastDfsFileClientRegister() {
            return new FileClientRegister.AbstractFileClientRegister(){

                @Override
                public void register(BeanDefinitionRegistry registry, Environment environment, List<FileSystemTemplateRegister> fileSystemTemplateRegisters, FileProperties fileProperties) {
                    List<FastDfsConfig> fastDfsConfigs = this.listBind(environment, FastDfsConfig.class, StringUtils.builder0((Object[])new Object[]{"yusp.file", ".", "fastdfses"}));
                    super.register(registry, FastDfsFileClient.class, fastDfsConfigs, fileProperties.getConnectionPool(), fileSystemTemplateRegisters, beanDefinitionBuilder -> beanDefinitionBuilder.addConstructorArgReference(FastDfsFileClientAutoConfiguration.FAST_DFS_COMMAND_SERVICE_BEAN_NAME));
                }
            };
        }
    }
}

