/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.distributed.lock;

import cn.com.yusys.yusp.commons.autoconfigure.distributed.lock.LockProperties;
import cn.com.yusys.yusp.commons.distributed.lock.Lock;
import cn.com.yusys.yusp.commons.distributed.lock.LockUtils;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DatabaseDistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.LockImpl;
import cn.com.yusys.yusp.commons.distributed.lock.impl.RedisDistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.ZookeeperDistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.mapper.LockInfoMapper;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.service.LockInfoService;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.mybatis.spring.annotation.MapperScan;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Lock.class})
public class LockAutoConfiguration {
    public static final String LOCK_PREFIX = "yusp.lock";
    public static final String REDIS_LOCK_PREFIX = "yusp.lock.redis";
    public static final String REDIS = "redis://";

    @Configuration
    @ConditionalOnClass(value={Lock.class})
    @AutoConfigureAfter(value={ZookeeperDistributedLockAutoConfiguration.class, DatabaseDistributedLockAutoConfiguration.class, RedisDistributedLockAutoConfiguration.class})
    @ConditionalOnProperty(prefix="yusp.lock", name={"enabled"}, matchIfMissing=true)
    static class DistributedLockAutoConfiguration {
        DistributedLockAutoConfiguration() {
        }

        @Bean
        public Lock lockImpl(DistributedLock distributedLock) {
            return new LockImpl(distributedLock);
        }

        @Bean
        public LockUtils lockUtils() {
            return new LockUtils();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="yusp.lock", name={"type"}, havingValue="redis")
    @ConditionalOnClass(value={Lock.class})
    static class RedisDistributedLockAutoConfiguration {
        RedisDistributedLockAutoConfiguration() {
        }

        @Bean
        @ConditionalOnExpression(value="'cluster'.equals('${yusp.lock.redis.type:cluster}')")
        public RedissonClient getRedissionClusterClient(RedisProperties redisProperties) {
            Config config = new Config();
            List clusterNodes = redisProperties.getCluster().getNodes();
            for (int i = 0; i < clusterNodes.size(); ++i) {
                clusterNodes.set(i, LockAutoConfiguration.REDIS + (String)clusterNodes.get(i));
            }
            if (StringUtils.nonBlank((CharSequence)redisProperties.getPassword())) {
                config.useClusterServers().addNodeAddress(clusterNodes.toArray(new String[clusterNodes.size()])).setPassword(redisProperties.getPassword());
            } else {
                config.useClusterServers().addNodeAddress(clusterNodes.toArray(new String[clusterNodes.size()]));
            }
            return Redisson.create((Config)config);
        }

        @Bean
        @ConditionalOnProperty(prefix="yusp.lock.redis", name={"type"}, havingValue="single")
        public RedissonClient getRedissionSingleClient(RedisProperties redisProperties) {
            Config config = new Config();
            String address = LockAutoConfiguration.REDIS + redisProperties.getHost() + ":" + redisProperties.getPort();
            if (StringUtils.nonBlank((CharSequence)redisProperties.getPassword())) {
                config.useSingleServer().setAddress(address).setDatabase(redisProperties.getDatabase()).setPassword(redisProperties.getPassword());
            } else {
                config.useSingleServer().setAddress(address).setDatabase(redisProperties.getDatabase());
            }
            return Redisson.create((Config)config);
        }

        @Bean
        @ConditionalOnProperty(prefix="yusp.lock.redis", name={"type"}, havingValue="sentinel")
        public RedissonClient getRedissionSentinalClient(RedisProperties redisProperties) {
            Config config = new Config();
            List sentinelNodeList = redisProperties.getSentinel().getNodes();
            for (int i = 0; i < sentinelNodeList.size(); ++i) {
                sentinelNodeList.set(i, LockAutoConfiguration.REDIS + (String)sentinelNodeList.get(i));
            }
            if (StringUtils.nonBlank((CharSequence)redisProperties.getPassword())) {
                ((SentinelServersConfig)config.useSentinelServers().addSentinelAddress(sentinelNodeList.toArray(new String[sentinelNodeList.size()])).setMasterName(redisProperties.getSentinel().getMaster()).setPassword(redisProperties.getSentinel().getPassword())).setDatabase(redisProperties.getDatabase());
            } else {
                config.useSentinelServers().addSentinelAddress(sentinelNodeList.toArray(new String[sentinelNodeList.size()])).setMasterName(redisProperties.getSentinel().getMaster()).setDatabase(redisProperties.getDatabase());
            }
            return Redisson.create((Config)config);
        }

        @Bean
        public DistributedLock lockImplDb() {
            return new RedisDistributedLock(30000L);
        }
    }

    @Configuration
    @ConditionalOnClass(value={CuratorFramework.class, Lock.class})
    @ConditionalOnExpression(value="'zookeeper'.equals('${yusp.lock.type:zookeeper}')")
    @EnableConfigurationProperties(value={LockProperties.class})
    static class ZookeeperDistributedLockAutoConfiguration {
        ZookeeperDistributedLockAutoConfiguration() {
        }

        @Bean
        public CuratorFramework curatorFramework(LockProperties properties) {
            CuratorFramework zookeeperClient = CuratorFrameworkFactory.newClient((String)properties.getZookeeper().getAddress(), (int)properties.getZookeeper().getSessionTimeout(), (int)properties.getZookeeper().getConnectionTimeout(), (RetryPolicy)new RetryNTimes(properties.getZookeeper().getRetryNum(), properties.getZookeeper().getElapsedTime()));
            zookeeperClient.start();
            return zookeeperClient;
        }

        @Bean
        public DistributedLock zookeeperDistributedLock(CuratorFramework zookeeperClient) {
            return new ZookeeperDistributedLock(zookeeperClient);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="yusp.lock", name={"type"}, havingValue="database")
    @ConditionalOnClass(value={Lock.class})
    @EnableConfigurationProperties(value={LockProperties.class})
    @MapperScan(value={"cn.com.yusys.yusp.commons.distributed.lock.impl.db.mapper"})
    static class DatabaseDistributedLockAutoConfiguration {
        DatabaseDistributedLockAutoConfiguration() {
        }

        @Bean
        public LockInfoService lockInfoService(LockInfoMapper lockInfoMapper) {
            return new LockInfoService(lockInfoMapper);
        }

        @Bean
        public DistributedLock lockImplDb(LockInfoService lockInfoService, LockProperties lockProperties) {
            return new DatabaseDistributedLock(lockInfoService, lockProperties.getDatabase().getTimeout());
        }
    }
}

