/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.data.authority;

import cn.com.yusys.yusp.commons.autoconfigure.data.authority.DataAuthorityAutoConfiguration;
import cn.com.yusys.yusp.commons.data.authority.DataAuthoritySql;
import cn.com.yusys.yusp.commons.data.authority.assemble.helper.MybatisPlusAdapter;
import cn.com.yusys.yusp.commons.data.authority.assemble.helper.PageHelperAdapter;
import cn.com.yusys.yusp.commons.data.authority.assemble.helper.SelectBodyHelperUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, DataAuthoritySql.class})
public class MybatisExtensionAdapterAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={DataAuthoritySql.class})
    @AutoConfigureAfter(value={DataSourceAutoConfiguration.class, DataAuthorityAutoConfiguration.class})
    static class DialectAutoConfiguration {
        private static final String PAGE_HELPER_CLASS = "com.github.pagehelper.PageHelper";
        private static final String PAGINATION_CLASS = "com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor";
        private static final String PAGE_HELPER_ADAPTER_CLASS = "cn.com.yusys.yusp.commons.mybatis.pagehelper.OracleDialectAdapter";

        public DialectAutoConfiguration(ObjectProvider<List<DataSource>> dataSourceProvider) {
            this.setSelectBodyHelper((List)dataSourceProvider.getIfAvailable());
        }

        public void setSelectBodyHelper(List<DataSource> dataSources) {
            if (ReflectionUtils.isPresent((String)PAGE_HELPER_CLASS)) {
                boolean isAdapter = ReflectionUtils.isPresent((String)PAGE_HELPER_ADAPTER_CLASS);
                PageHelperAdapter.pageHelperDialectRegister((boolean)isAdapter);
            }
            if (ReflectionUtils.isPresent((String)PAGINATION_CLASS)) {
                MybatisPlusAdapter.mybatisPlusPageDialectRegister();
            }
            SelectBodyHelperUtils.initSelectBodyHelpers(dataSources);
        }
    }
}

