/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.data.authority;

import cn.com.yusys.yusp.commons.autoconfigure.data.authority.DataAuthorityProperties;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.MybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.data.authority.DataAuthoritySql;
import cn.com.yusys.yusp.commons.data.authority.DataAuthorizationService;
import cn.com.yusys.yusp.commons.data.authority.User;
import cn.com.yusys.yusp.commons.data.authority.UserInformationService;
import cn.com.yusys.yusp.commons.data.authority.assemble.DataAuthorityAssembleInterceptor;
import cn.com.yusys.yusp.commons.data.authority.assemble.DataAuthorityAssembleSql;
import cn.com.yusys.yusp.commons.data.authority.cache.DataAuthorityCache;
import cn.com.yusys.yusp.commons.data.authority.cache.DataAuthorityCacheManager;
import cn.com.yusys.yusp.commons.data.authority.cache.MemoryDataAuthorityCache;
import cn.com.yusys.yusp.commons.data.authority.replace.DataAuthorityReplaceInterceptor;
import cn.com.yusys.yusp.commons.data.authority.replace.DataAuthorityReplaceSql;
import cn.com.yusys.yusp.commons.data.authority.support.CacheableGetDataAuthorizationService;
import cn.com.yusys.yusp.commons.data.authority.support.RemoteGetDataAuthorizationService;
import cn.com.yusys.yusp.commons.data.authority.web.filter.DataAuthorityWebFilter;
import cn.com.yusys.yusp.commons.data.authority.xmltags.DefaultLanguageDriver;
import cn.com.yusys.yusp.commons.data.authority.xmltags.MybatisPlusLanguageDriverAdapter;
import cn.com.yusys.yusp.commons.mybatis.ConfigurationCustomizer;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import cn.com.yusys.yusp.commons.util.collection.MapUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={DataAuthorityProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, DataAuthoritySql.class})
@AutoConfigureBefore(value={MybatisAutoConfiguration.class})
public class DataAuthorityAutoConfiguration {
    DataAuthorityProperties dataAuthorityProperties;

    public DataAuthorityAutoConfiguration(DataAuthorityProperties dataAuthorityProperties) {
        this.dataAuthorityProperties = dataAuthorityProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="yusp.data-authority", name={"config-get-type"}, havingValue="remote")
    public DataAuthorizationService remoteServiceGetDataAuthorizationService() {
        return new RemoteGetDataAuthorizationService(this.dataAuthorityProperties.getRemotePath());
    }

    @Autowired
    public void setDataAuthorityCache(@Autowired(required=false) DataAuthorityCache dataAuthorityCache) {
        DataAuthorityCacheManager.setDataAuthorityCache((DataAuthorityCache)(Objects.nonNull(dataAuthorityCache) ? dataAuthorityCache : new MemoryDataAuthorityCache()));
        DataAuthorityCacheManager.addCache((String)"ignoredMapperIds", (Object)ListUtils.emptyList(this.dataAuthorityProperties.getIgnoredMapperIds()));
        DataAuthorityCacheManager.addCache((String)"effectiveMapperIds", (Object)ListUtils.emptyList(this.dataAuthorityProperties.getEffectiveMapperIds()));
    }

    @Bean
    @ConditionalOnMissingBean(value={UserInformationService.class})
    public UserInformationService userInformationService() {
        return new User();
    }

    @Bean
    @ConditionalOnBean(value={DataAuthorizationService.class, UserInformationService.class})
    public FilterRegistrationBean<Filter> dataAuthorityFilter(DataAuthorizationService dataAuthorizationConfig, UserInformationService userService) {
        FilterRegistrationBean filterBean = new FilterRegistrationBean();
        filterBean.addUrlPatterns(new String[]{"/*"});
        filterBean.setOrder(0);
        filterBean.setName(DataAuthorityWebFilter.class.getSimpleName());
        HashMap initMap = MapUtils.newHashMap();
        initMap.put("ignoreUrls", this.dataAuthorityProperties.getIgnoredApi());
        filterBean.setInitParameters((Map)initMap);
        filterBean.setFilter((Filter)new DataAuthorityWebFilter(dataAuthorizationConfig, userService));
        return filterBean;
    }

    @Bean
    @Order(value=0)
    public ConfigurationCustomizer customizedConfiguration() {
        String PAGINATION_CLASS = "com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor";
        Class languageDriverClassType = ReflectionUtils.isPresent((String)PAGINATION_CLASS) ? MybatisPlusLanguageDriverAdapter.class : DefaultLanguageDriver.class;
        return configuration -> configuration.getLanguageRegistry().setDefaultDriverClass(languageDriverClassType);
    }

    @Configuration
    @ConditionalOnClass(value={DataAuthoritySql.class})
    @ConditionalOnExpression(value="'replace'.equals('${yusp.data-authority.type:replace}')")
    public class ReplaceDataAuthority {
        @Bean
        public DataAuthorityReplaceSql dataAuthorityReplaceSql() {
            return new DataAuthorityReplaceSql(DataAuthorityAutoConfiguration.this.dataAuthorityProperties.getTemplateAcqType());
        }

        @Bean
        @Order(value=-4)
        public Interceptor dataAuthorityReplaceInterceptor(DataAuthorityReplaceSql dataAuthorityReplaceSql) {
            return new DataAuthorityReplaceInterceptor(dataAuthorityReplaceSql, DataAuthorityAutoConfiguration.this.dataAuthorityProperties.isGlobalIgnored());
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataAuthoritySql.class})
    @ConditionalOnExpression(value="'assemble'.equals('${yusp.data-authority.type:assemble}')")
    public class AssembleDataAuthority {
        @Bean
        public DataAuthorityAssembleSql dataAuthorityAssembleSql() {
            return new DataAuthorityAssembleSql(DataAuthorityAutoConfiguration.this.dataAuthorityProperties.getTemplateAcqType());
        }

        @Bean
        @Order(value=1)
        public Interceptor dataAuthorityAssembleInterceptor(DataAuthorityAssembleSql dataAuthorityAssembleSql) {
            return new DataAuthorityAssembleInterceptor(dataAuthorityAssembleSql, DataAuthorityAutoConfiguration.this.dataAuthorityProperties.isGlobalIgnored());
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.data.redis.connection.RedisConnectionFactory"}, value={DataAuthoritySql.class})
    @ConditionalOnMissingBean(value={DataAuthorizationService.class})
    @ConditionalOnProperty(prefix="yusp.data-authority", name={"config-get-type"}, havingValue="redis")
    public class RedisGetConfigAutoConfiguration {
        @Bean
        public CacheableGetDataAuthorizationService.CacheableGetService cacheableGetService() {
            return new CacheableGetDataAuthorizationService.CacheableGetService();
        }

        @Bean
        public DataAuthorizationService redisGetDataAuthorityService(CacheableGetDataAuthorizationService.CacheableGetService cacheableGetService) {
            return new CacheableGetDataAuthorizationService(cacheableGetService, DataAuthorityAutoConfiguration.this.dataAuthorityProperties.getCacheName());
        }
    }
}

