/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.sequence;

import cn.com.yusys.yusp.commons.autoconfigure.sequence.SequenceProperties;
import cn.com.yusys.yusp.commons.sequence.Sequence;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.TimedCleanExpiredSequenceId;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.sequence.generator.algorithm.SnowflakeSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.generator.db.Db2SequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.generator.db.MySqlSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.generator.db.OracleSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.generator.db.SqlServerSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.generator.nosql.RedisSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

@ConditionalOnClass(value={Sequence.class})
@EnableConfigurationProperties(value={SequenceProperties.class})
@EnableScheduling
public class SequenceAutoConfiguration {
    @Bean
    public SequenceBeanDefinitionRegistryPostProcessor sequenceBeanDefinitionRegistryPostProcessor() {
        return new SequenceBeanDefinitionRegistryPostProcessor();
    }

    static class SequenceBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor,
    ApplicationContextAware {
        private static final String JDBC_TEMPLATE_CLASS = "org.springframework.jdbc.core.JdbcTemplate";
        private static final String STRING_REDIS_TEMPLATE_CLASS = "org.springframework.data.redis.core.StringRedisTemplate";
        static final Map<GeneratorType, Class<?>> DB_SEQUENCE_BEAN_MAPS = new ConcurrentHashMap(6);
        private ApplicationContext applicationContext;
        private DefaultListableBeanFactory registry;

        SequenceBeanDefinitionRegistryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (registry instanceof DefaultListableBeanFactory) {
                this.registry = (DefaultListableBeanFactory)registry;
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            ConfigurationProperties annotation = SequenceProperties.class.getAnnotation(ConfigurationProperties.class);
            SequenceProperties properties = new SequenceProperties();
            Binder binder = Binder.get((Environment)this.applicationContext.getEnvironment());
            binder.bind(annotation.prefix(), Bindable.ofInstance((Object)properties).withAnnotations(new Annotation[]{annotation}));
            if (Objects.nonNull(this.registry)) {
                ObjectProvider sequenceIdConverters = this.registry.getBeanProvider(SequenceIdConverter.class);
                if (ReflectionUtils.isPresent((String)JDBC_TEMPLATE_CLASS)) {
                    this.dbSequenceRegistry((BeanDefinitionRegistry)this.registry, properties, this.registry.getBeanNamesForType(ReflectionUtils.forName((String)JDBC_TEMPLATE_CLASS)), (ObjectProvider<SequenceIdConverter>)sequenceIdConverters);
                }
                if (ReflectionUtils.isPresent((String)STRING_REDIS_TEMPLATE_CLASS)) {
                    SequenceBeanDefinitionRegistryPostProcessor.redisSequenceRegistry((BeanDefinitionRegistry)this.registry, properties, this.registry.getBeanNamesForType(ReflectionUtils.forName((String)STRING_REDIS_TEMPLATE_CLASS)), (ObjectProvider<SequenceIdConverter>)sequenceIdConverters);
                }
                SequenceBeanDefinitionRegistryPostProcessor.algorithmSequenceRegistry((BeanDefinitionRegistry)this.registry, properties, (ObjectProvider<SequenceIdConverter>)sequenceIdConverters);
                SequenceUtils.initialing((String)properties.getUseType());
                this.registryCleanExpiredBean((BeanDefinitionRegistry)this.registry, (ObjectProvider<List<Sequence>>)this.registry.getBeanProvider(ResolvableType.forClass(Sequence.class)), (ObjectProvider<SequenceIdConverter>)sequenceIdConverters, properties.getCleanup());
            }
        }

        void dbSequenceRegistry(BeanDefinitionRegistry registry, SequenceProperties properties, String[] jdbcTemplateBeanNames, ObjectProvider<SequenceIdConverter> sequenceIdConverterObjectProvider) {
            if (ArrayUtils.nonEmpty((Object[])jdbcTemplateBeanNames)) {
                String[] defaultGeneratorTypes = (String[])Stream.of(GeneratorType.values()).map(Enum::name).toArray(String[]::new);
                Optional.ofNullable(properties.getGenerateType()).filter(StringUtils::nonEmpty).ifPresent(configGenerateType -> Arrays.stream(StringUtils.split((String)configGenerateType, (String)",")).map(StringUtils::trim).filter(StringUtils::nonEmpty).map(StringUtils::upperCase).filter(type -> ArrayUtils.contains((Object[])defaultGeneratorTypes, (Object)type)).map(GeneratorType::valueOf).filter(DB_SEQUENCE_BEAN_MAPS::containsKey).forEach(generateType -> {
                    Class<?> classType = DB_SEQUENCE_BEAN_MAPS.get(generateType);
                    BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(classType);
                    builder.addConstructorArgValue(properties.getConfigs());
                    builder.addConstructorArgValue(sequenceIdConverterObjectProvider.getIfAvailable());
                    builder.addConstructorArgReference(jdbcTemplateBeanNames[0]);
                    registry.registerBeanDefinition(classType.getName(), (BeanDefinition)builder.getBeanDefinition());
                }));
            }
        }

        static void redisSequenceRegistry(BeanDefinitionRegistry registry, SequenceProperties properties, String[] stringRedisTemplateBeanNames, ObjectProvider<SequenceIdConverter> sequenceIdConverterObjectProvider) {
            if (ArrayUtils.nonEmpty((Object[])stringRedisTemplateBeanNames) && SequenceBeanDefinitionRegistryPostProcessor.isSupportRedis(properties.getGenerateType())) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RedisSequenceGenerator.class);
                builder.addConstructorArgValue(properties.getConfigs());
                builder.addConstructorArgValue(sequenceIdConverterObjectProvider.getIfAvailable());
                builder.addConstructorArgReference(stringRedisTemplateBeanNames[0]);
                registry.registerBeanDefinition(RedisSequenceGenerator.class.getName(), (BeanDefinition)builder.getBeanDefinition());
            }
        }

        static void algorithmSequenceRegistry(BeanDefinitionRegistry registry, SequenceProperties properties, ObjectProvider<SequenceIdConverter> sequenceIdConverterObjectProvider) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SnowflakeSequenceGenerator.class);
            builder.addConstructorArgValue(properties.getConfigs());
            builder.addConstructorArgValue(sequenceIdConverterObjectProvider.getIfAvailable());
            registry.registerBeanDefinition(SnowflakeSequenceGenerator.class.getName(), (BeanDefinition)builder.getBeanDefinition());
        }

        static boolean isSupportRedis(String configGenerateType) {
            return StringUtils.nonEmpty((CharSequence)configGenerateType) && configGenerateType.toUpperCase().contains("REDIS");
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        private void registryCleanExpiredBean(BeanDefinitionRegistry registry, ObjectProvider<List<Sequence>> sequences, ObjectProvider<SequenceIdConverter> sequenceIdConverterObjectProvider, SequenceProperties.Cleanup cleanup) {
            if (cleanup.isEnabled()) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(TimedCleanExpiredSequenceId.class);
                builder.addConstructorArgValue(sequences.getIfAvailable());
                builder.addConstructorArgValue(sequenceIdConverterObjectProvider.getIfAvailable());
                builder.addConstructorArgValue((Object)cleanup.getCleanExpiredCount());
                builder.addConstructorArgValue((Object)cleanup.getReserveCount());
                registry.registerBeanDefinition(TimedCleanExpiredSequenceId.class.getName(), (BeanDefinition)builder.getBeanDefinition());
            }
        }

        static {
            DB_SEQUENCE_BEAN_MAPS.put(GeneratorType.DB2, Db2SequenceGenerator.class);
            DB_SEQUENCE_BEAN_MAPS.put(GeneratorType.ORACLE, OracleSequenceGenerator.class);
            DB_SEQUENCE_BEAN_MAPS.put(GeneratorType.MYSQL, MySqlSequenceGenerator.class);
            DB_SEQUENCE_BEAN_MAPS.put(GeneratorType.SQLSERVER, SqlServerSequenceGenerator.class);
        }
    }
}

