/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.okhttp;

import cn.com.yusys.yusp.commons.autoconfigure.okhttp.OkHttpProperties;
import cn.com.yusys.yusp.commons.autoconfigure.okhttp.TokenCopyInterceptor;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import feign.Feign;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Feign.class, FeignAutoConfiguration.class, Interceptor.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@ConditionalOnProperty(value={"feign.okhttp.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={OkHttpProperties.class})
public class OkHttpAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OkHttpAutoConfiguration.class);
    private OkHttpProperties properties;

    public OkHttpAutoConfiguration(OkHttpProperties properties) {
        this.properties = properties;
    }

    @Bean
    public OkHttpClient okHttpClient() {
        log.debug("Auto configuration >> okHttpClient configuration completed");
        return new OkHttpClient.Builder().readTimeout((long)this.properties.getHttpReadTimeout(), TimeUnit.MILLISECONDS).connectTimeout((long)this.properties.getConnectTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)this.properties.getWriteTimeout(), TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool()).addInterceptor((Interceptor)this.tokenCopyInterceptor()).build();
    }

    public TokenCopyInterceptor tokenCopyInterceptor() {
        log.debug("Auto configuration >> okHttp auto configuration interceptor completed");
        return new TokenCopyInterceptor(SpringContextUtils.getApplicationName());
    }
}

