/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.log.message;

import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.log.ApiData;
import cn.com.yusys.yusp.commons.log.ApiLogHelper;
import cn.com.yusys.yusp.commons.message.consumer.interceptor.AbstractMessageEventInterceptor;
import cn.com.yusys.yusp.commons.message.consumer.interceptor.MessageEventInterceptorChain;
import cn.com.yusys.yusp.commons.message.util.MessageHeaderUtils;
import org.springframework.messaging.Message;

public class MessageLogInterceptor
extends AbstractMessageEventInterceptor {
    private ThreadLocal<ApiData> logLocal = new ThreadLocal();
    private final ApiLogHelper apiLogHelper;

    public MessageLogInterceptor(ApiLogHelper apiLogHelper) {
        this.apiLogHelper = apiLogHelper;
    }

    private ApiData loadFromLocal() {
        return this.logLocal.get();
    }

    public void doHandle(Message<?> message, MessageEventInterceptorChain chain) throws PlatformException {
        String event = MessageHeaderUtils.event(message);
        try {
            this.apiLogHelper.logInvoke("Message: " + event, "handleMessage", () -> super.doHandle(message, chain), new Object[]{message.getPayload()}, true);
        }
        catch (Throwable throwable) {
            throw new PlatformException(throwable.getMessage());
        }
    }
}

