/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.exception;

import cn.com.yusys.yusp.commons.autoconfigure.context.MessageSpecProperties;
import cn.com.yusys.yusp.commons.exception.fegin.FeignErrorDecoder;
import cn.com.yusys.yusp.commons.exception.rest.BizExceptionResponseInterceptor;
import cn.com.yusys.yusp.commons.exception.web.ExceptionTranslator;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionAfterHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.ExceptionAfterHandlerImpl;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.ExceptionHandlerImpl;
import cn.com.yusys.yusp.commons.security.exception.AuthExceptionHandler;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={MessageSpecProperties.class})
@ConditionalOnClass(value={ExceptionTranslator.class})
@ConditionalOnProperty(name={"yusp.exception.enabled"}, havingValue="true", matchIfMissing=true)
public class WebExceptionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebExceptionAutoConfiguration.class);

    @Bean
    public ExceptionAfterHandlerImpl exceptionAfterHandlerImpl() {
        return new ExceptionAfterHandlerImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionHandlerImpl exceptionHandlerImpl(ObjectProvider<IExceptionAfterHandler> provider, MessageSpecProperties properties) {
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl((IExceptionAfterHandler)provider.getIfAvailable());
        exceptionHandler.setSeverExceptionMessage(properties.getServerExceptionMsg());
        return exceptionHandler;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionTranslator exceptionTranslator(ObjectProvider<IExceptionHandler<? extends Exception>> provider) {
        List interfaces = provider.orderedStream().collect(Collectors.toList());
        return new ExceptionTranslator(interfaces);
    }

    @Configuration
    @ConditionalOnClass(value={AuthExceptionHandler.class})
    static class SecurityExceptionConfiguration {
        SecurityExceptionConfiguration() {
        }

        @Bean
        @Order(value=0)
        public AuthExceptionHandler authExceptionHandler(ObjectProvider<IExceptionAfterHandler> afterHandlerInterfaces, MessageSpecProperties messageSpecProperties) {
            AuthExceptionHandler authExceptionHandler = new AuthExceptionHandler((IExceptionAfterHandler)afterHandlerInterfaces.getIfAvailable());
            authExceptionHandler.setSeverExceptionMessage(messageSpecProperties.getServerExceptionMsg());
            return authExceptionHandler;
        }
    }

    @Configuration
    @ConditionalOnClass(name={"feign.Feign", "org.springframework.cloud.openfeign.FeignContext", "cn.com.yusys.yusp.commons.exception.web.handler.IExceptionAfterHandler"})
    static class FeignErrorAutoConfiguration {
        FeignErrorAutoConfiguration() {
        }

        @Bean
        public FeignErrorDecoder yuspFeignErrorDecoder() {
            return new FeignErrorDecoder();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class, RestTemplateCustomizer.class, BizExceptionResponseInterceptor.class})
    static class RestExceptionConfiguration {
        RestExceptionConfiguration() {
        }

        @Order(value=2147483627)
        @Bean
        @ConditionalOnMissingBean
        public BizExceptionResponseInterceptor bizExceptionResponseInterceptor() {
            log.debug("Inject BizExceptionResponseInterceptor.");
            return new BizExceptionResponseInterceptor();
        }
    }
}

