/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.data.route;

import cn.com.yusys.yusp.commons.autoconfigure.data.route.DataRouteProperties;
import cn.com.yusys.yusp.commons.autoconfigure.data.route.PropertyUtil;
import cn.com.yusys.yusp.commons.route.jdbc.core.datasource.YuspDataSource;
import cn.com.yusys.yusp.commons.route.mybatis.DataRouteNameInterceptor;
import cn.com.yusys.yusp.commons.route.mybatis.DataRoutePropertiesDto;
import cn.com.yusys.yusp.commons.route.util.DataSourceUtil;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={YuspDataSource.class})
@ConditionalOnProperty(name={"spring.shardingsphere.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DataRouteProperties.class})
public class DataRouteAutoConfiguration
implements EnvironmentAware {
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DataRouteProperties dataRouteProperties;

    public DataRouteAutoConfiguration(DataRouteProperties dataRouteProperties) {
        this.dataRouteProperties = dataRouteProperties;
    }

    @Bean
    public DataSource yuspDataSource() throws SQLException {
        return new YuspDataSource(this.dataSourceMap, this.dataRouteProperties.getDefaultDataSourceName());
    }

    @Bean
    public Interceptor dataSourceNameInterceptor() {
        DataRouteNameInterceptor interceptor = new DataRouteNameInterceptor();
        DataRoutePropertiesDto propertiesDto = new DataRoutePropertiesDto();
        propertiesDto.setDefaultDataSourceName(this.dataRouteProperties.getDefaultDataSourceName());
        List<String> namespaces = this.dataRouteProperties.getMultiple();
        if (null == namespaces) {
            this.log.warn("no data-source-route in config !!!");
        } else {
            for (String namespaceT : namespaces) {
                String[] strArr = namespaceT.split("->");
                String namespace = strArr[0].trim();
                String dataSourceName = strArr[1].trim();
                propertiesDto.addNameSpace(namespace, dataSourceName);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("success add data-source-route in: {}, dataSourceName: {}", (Object)namespace, (Object)dataSourceName);
            }
        }
        interceptor.setDataSourceRouteDto(propertiesDto);
        return interceptor;
    }

    public final void setEnvironment(Environment environment) {
        String prefix = "spring.shardingsphere.datasource.";
        for (String each : this.getDataSourceNames(environment, prefix)) {
            try {
                this.dataSourceMap.put(each.trim(), this.getDataSource(environment, prefix, each.trim()));
            }
            catch (Exception ex) {
                throw new RuntimeException("datasource config error!", ex);
            }
        }
    }

    private String[] getDataSourceNames(Environment environment, String prefix) {
        return environment.getProperty(prefix + "names").split(",");
    }

    private DataSource getDataSource(Environment environment, String prefix, String dataSourceName) throws Exception {
        Map dataSourceProps = PropertyUtil.handle(environment, prefix + dataSourceName.trim(), Map.class);
        Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (Object)"Wrong datasource properties!");
        DataSource result = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
        return result;
    }
}

