/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.crypt;

import cn.com.yusys.yusp.commons.crypt.DecryptPropertyService;
import cn.com.yusys.yusp.commons.crypt.DesDecryptPropertyService;
import cn.com.yusys.yusp.commons.crypt.EncryptionPropertyResolver;
import cn.com.yusys.yusp.commons.crypt.RsaDecryptPropertyService;
import cn.com.yusys.yusp.commons.crypt.listener.CryptApplicationListener;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.configuration.EnableEncryptablePropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DecryptPropertyService.class})
@AutoConfigureBefore(value={EnableEncryptablePropertiesConfiguration.class})
class CryptAutoConfiguration {
    public static final String CRYPT_PREFIX = "yusp.crypt";
    private static final Logger logger = LoggerFactory.getLogger(CryptAutoConfiguration.class);

    CryptAutoConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(name={"yusp.crypt.type"}, havingValue="RSA")
    public DecryptPropertyService rsaDecryptPropertyService() {
        logger.debug("Auto configuration >> RAS based properties encryption and decryption bean loading");
        return new RsaDecryptPropertyService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DecryptPropertyService desDecryptPropertyService() {
        logger.debug("Auto configuration >> DES based properties encryption and decryption bean loading");
        return new DesDecryptPropertyService();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.context.environment.EnvironmentChangeEvent"})
    public CryptApplicationListener cryptApplicationListener() {
        return new CryptApplicationListener();
    }

    @Bean
    public EncryptablePropertyResolver encryptablePropertyResolver(DecryptPropertyService decryptPropertyService) {
        return new EncryptionPropertyResolver(decryptPropertyService);
    }
}

