/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.KeyUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.Mode;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.Padding;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.SymmetricAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public AES() {
        super(SymmetricAlgorithm.AES);
    }

    public AES(byte[] key) {
        super(SymmetricAlgorithm.AES, key);
    }

    public AES(SecretKey key) {
        super(SymmetricAlgorithm.AES, key);
    }

    public AES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public AES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null);
    }

    public AES(Mode mode, Padding padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, ArrayUtils.isEmpty(iv) ? null : new IvParameterSpec(iv));
    }

    public AES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public AES(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, KeyUtils.generateKey(SymmetricAlgorithm.AES.getValue(), key), ArrayUtils.isEmpty(iv) ? null : new IvParameterSpec(iv));
    }

    public AES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(String.format("AES/%s/%s", mode, padding), key, iv);
    }
}

