/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto;

import cn.com.yusys.yusp.commons.util.HexUtils;
import cn.com.yusys.yusp.commons.util.RegExpUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.MapUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.CryptoException;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.GlobalBouncyCastleProvider;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.KeyUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.AsymmetricAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.RSA;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.Sign;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.asymmetric.SignAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.DigestAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.Digester;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.HMac;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.HmacAlgorithm;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.digest.MD5;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.AES;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.DES;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.DESede;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.RC4;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.symmetric.SymmetricCrypto;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class SecureUtils {
    public static final int DEFAULT_KEY_SIZE = 1024;

    public static SecretKey generateKey(String algorithm) {
        return KeyUtils.generateKey(algorithm);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return KeyUtils.generateKey(algorithm, keySize);
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        return KeyUtils.generateKey(algorithm, key);
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        return KeyUtils.generateDESKey(algorithm, key);
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        return KeyUtils.generatePBEKey(algorithm, key);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        return KeyUtils.generateKey(algorithm, keySpec);
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        return KeyUtils.generatePrivateKey(algorithm, key);
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        return KeyUtils.generatePrivateKey(algorithm, keySpec);
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        return KeyUtils.generatePrivateKey(keyStore, alias, password);
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        return KeyUtils.generatePublicKey(algorithm, key);
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        return KeyUtils.generatePublicKey(algorithm, keySpec);
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return KeyUtils.generateKeyPair(algorithm);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return KeyUtils.generateKeyPair(algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        return KeyUtils.generateKeyPair(algorithm, keySize, seed);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return KeyUtils.generateKeyPair(algorithm, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec params) {
        return KeyUtils.generateKeyPair(algorithm, seed, params);
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        return KeyUtils.getAlgorithmAfterWith(algorithm);
    }

    public static String generateAlgorithm(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        String digestPart = null == digestAlgorithm ? "NONE" : digestAlgorithm.name();
        return StringUtils.format("{}with{}", digestPart, asymmetricAlgorithm.getValue());
    }

    public static Signature generateSignature(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        try {
            return Signature.getInstance(SecureUtils.generateAlgorithm(asymmetricAlgorithm, digestAlgorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return KeyUtils.readJKSKeyStore(in, password);
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        return KeyUtils.readKeyStore(type, in, password);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return KeyUtils.readX509Certificate(in, password, alias);
    }

    public static Certificate readX509Certificate(InputStream in) {
        return KeyUtils.readX509Certificate(in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        return KeyUtils.readCertificate(type, in, password, alias);
    }

    public static Certificate readCertificate(String type, InputStream in) {
        return KeyUtils.readCertificate(type, in);
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        return KeyUtils.getCertificate(keyStore, alias);
    }

    public static AES aes() {
        return new AES();
    }

    public static AES aes(byte[] key) {
        return new AES(key);
    }

    public static DES des() {
        return new DES();
    }

    public static DES des(byte[] key) {
        return new DES(key);
    }

    public static DESede desede() {
        return new DESede();
    }

    public static DESede desede(byte[] key) {
        return new DESede(key);
    }

    public static MD5 md5() {
        return new MD5();
    }

    public static String md5(String data) {
        return new MD5().digestHex(data);
    }

    public static String md5(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5(File dataFile) {
        return new MD5().digestHex(dataFile);
    }

    public static Digester sha1() {
        return new Digester(DigestAlgorithm.SHA1);
    }

    public static String sha1(String data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(InputStream data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(dataFile);
    }

    public static Digester sha256() {
        return new Digester(DigestAlgorithm.SHA256);
    }

    public static String sha256(String data) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data);
    }

    public static String sha256(InputStream data) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data);
    }

    public static String sha256(File dataFile) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(dataFile);
    }

    public static HMac hmac(HmacAlgorithm algorithm, String key) {
        return new HMac(algorithm, StringUtils.utf8Bytes(key));
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, (Key)key);
    }

    public static HMac hmacMd5(String key) {
        return SecureUtils.hmacMd5(StringUtils.utf8Bytes(key));
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac(HmacAlgorithm.HmacMD5, key);
    }

    public static HMac hmacMd5() {
        return new HMac(HmacAlgorithm.HmacMD5);
    }

    public static HMac hmacSha1(String key) {
        return SecureUtils.hmacSha1(StringUtils.utf8Bytes(key));
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSHA1, key);
    }

    public static HMac hmacSha1() {
        return new HMac(HmacAlgorithm.HmacSHA1);
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKeyBase64, String publicKeyBase64) {
        return new RSA(privateKeyBase64, publicKeyBase64);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static Sign sign(SignAlgorithm algorithm) {
        return new Sign(algorithm);
    }

    public static Sign sign(SignAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        return new Sign(algorithm, privateKeyBase64, publicKeyBase64);
    }

    public static Sign sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static String signParams(SymmetricCrypto crypto, Map<?, ?> params, String ... otherParams) {
        return SecureUtils.signParams(crypto, params, "", "", true, otherParams);
    }

    public static String signParams(SymmetricCrypto crypto, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return crypto.encryptHex(MapUtils.sortJoin(params, separator, keyValueSeparator, isIgnoreNull, otherParams));
    }

    public static String signParamsMd5(Map<?, ?> params, String ... otherParams) {
        return SecureUtils.signParams(DigestAlgorithm.MD5, params, otherParams);
    }

    public static String signParamsSha1(Map<?, ?> params, String ... otherParams) {
        return SecureUtils.signParams(DigestAlgorithm.SHA1, params, otherParams);
    }

    public static String signParamsSha256(Map<?, ?> params, String ... otherParams) {
        return SecureUtils.signParams(DigestAlgorithm.SHA256, params, otherParams);
    }

    public static String signParams(DigestAlgorithm digestAlgorithm, Map<?, ?> params, String ... otherParams) {
        return SecureUtils.signParams(digestAlgorithm, params, "", "", true, otherParams);
    }

    public static String signParams(DigestAlgorithm digestAlgorithm, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return new Digester(digestAlgorithm).digestHex(MapUtils.sortJoin(params, separator, keyValueSeparator, isIgnoreNull, otherParams));
    }

    public static void addProvider(Provider provider) {
        Security.insertProviderAt(provider, 0);
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String algorithm) {
        MessageDigest messageDigest;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return messageDigest;
    }

    public static Mac createMac(String algorithm) {
        Mac mac;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            mac = null == provider ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return mac;
    }

    public static RC4 rc4(String key) {
        return new RC4(key);
    }

    public static void disableBouncyCastle() {
        GlobalBouncyCastleProvider.setUseBouncyCastle(false);
    }

    public static byte[] decode(String key) {
        return RegExpUtils.isMatch(RegExpUtils.HEX, (CharSequence)key) ? HexUtils.decodeHex(key) : Base64.decodeBase64(key);
    }
}

