/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.collection;

import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListUtils {
    private ListUtils() {
    }

    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <E> List<E> newArrayList(E ... elements) {
        Asserts.nonNull(elements, "Element must not null!");
        int capacity = ListUtils.computeArrayListCapacity(elements.length);
        ArrayList arrayList = new ArrayList(capacity);
        Collections.addAll(arrayList, elements);
        return arrayList;
    }

    private static int computeArrayListCapacity(int arraySize) {
        Asserts.maxNumber(arraySize, 0, "Array size must greater than or equal to zero!");
        return NumberUtils.saturatedCastInt(arraySize + 1);
    }

    public static <E> List<E> newArrayList(Iterable<? extends E> elements) {
        List<E> list = ListUtils.newArrayList();
        CollectionUtils.addAll(list, elements);
        return list;
    }

    public static <E> List<E> newArrayList(Iterator<? extends E> elements) {
        List<E> list = ListUtils.newArrayList();
        CollectionUtils.addAll(list, elements);
        return list;
    }

    public static <E> List<E> newArrayListWithCapacity(int arraySize) {
        Asserts.maxNumber(arraySize, 0, "Init array size must greater than or equal to zero!");
        return new ArrayList(arraySize);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> List<E> newLinkedList(E ... elements) {
        Asserts.nonNull(elements, "Element must not null!");
        LinkedList arrayList = new LinkedList();
        Collections.addAll(arrayList, elements);
        return arrayList;
    }

    public static <E> List<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList linkedList = new LinkedList();
        CollectionUtils.addAll(linkedList, elements);
        return linkedList;
    }

    public static <E> List<E> newLinkedList(Iterator<? extends E> elements) {
        LinkedList linkedList = new LinkedList();
        CollectionUtils.addAll(linkedList, elements);
        return linkedList;
    }

    public static <E> List<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> List<E> newCopyOnWriteArrayList(E ... elements) {
        Asserts.nonNull(elements, "Element must not null!");
        return new CopyOnWriteArrayList<E>(elements);
    }

    public static <E> List<E> newCopyOnWriteArrayList(Iterable<? extends E> elements) {
        CopyOnWriteArrayList list = new CopyOnWriteArrayList();
        CollectionUtils.addAll(list, elements);
        return list;
    }

    public static <E> List<E> newCopyOnWriteArrayList(Iterator<? extends E> elements) {
        CopyOnWriteArrayList list = new CopyOnWriteArrayList();
        CollectionUtils.addAll(list, elements);
        return list;
    }

    public static <E> List<E> subArrayList(Collection<E> collection, int startIndex) {
        return ListUtils.subArrayList(collection, startIndex, collection.size() - startIndex);
    }

    public static <E> List<E> subArrayList(Collection<E> collection, int startIndex, int length) {
        if (Objects.isNull(collection) || collection.isEmpty()) {
            throw new IllegalArgumentException("the collection can not be null or empty");
        }
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("start index is smaller than zero");
        }
        int endIndex = startIndex + length;
        if (endIndex > collection.size()) {
            throw new IndexOutOfBoundsException("end index is greater than max index");
        }
        if (collection instanceof List) {
            return new ArrayList(((List)collection).subList(startIndex, endIndex));
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<E> iterator = collection.iterator();
        int tempIndex = 0;
        int count = 1;
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (tempIndex >= startIndex && count <= length) {
                result.add(e);
                ++count;
            }
            ++tempIndex;
        }
        return result;
    }

    public static <T> List<T> emptyList(List<T> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }
}

