/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper om = new ObjectMapper();

    private static JavaType collectionType(Class<?> collectionClz, Class<?> ... elementClz) {
        return om.getTypeFactory().constructParametricType(collectionClz, (Class[])elementClz);
    }

    public static <T> String toJson(T obj) {
        String json = null;
        if (obj != null) {
            try {
                json = om.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return json;
    }

    public static <T> T parse(Object object, Class<T> clazz) {
        return JsonUtils.parse(JsonUtils.toJson(object), clazz);
    }

    public static <T> T parse(String json, Class<T> clazz) {
        return JsonUtils.parse(json, clazz, null);
    }

    public static <T> T parse(String json, TypeReference<T> type) {
        return JsonUtils.parse(json, null, type);
    }

    public static <T> List<T> parseList(String json, Class<T> clazz) {
        try {
            return (List)om.readValue(json, JsonUtils.collectionType(List.class, clazz));
        }
        catch (JsonProcessingException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static <T> T parse(String json, Class<T> clazz, TypeReference<T> type) {
        Object obj = null;
        if (!StringUtils.isEmpty(json)) {
            try {
                obj = clazz != null ? om.readValue(json, clazz) : om.readValue(json, type);
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return (T)obj;
    }

    static {
        om.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        om.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

